<?php
session_start();
include "dbconn.php";

// Define your passkey securely
$correct_passkey = "9TS1X4Xw";

// If download is requested, verify session and export SQL
if (isset($_POST['download_sql'])) {
    if (!isset($_SESSION['passkey']) || $_SESSION['passkey'] !== $correct_passkey) {
        die("Unauthorized access.");
    }

    // Table to export
    $table = 'tdu_emails';
    $filename = $table . "_" . date("Y-m-d_H-i-s") . ".sql";

    // Start SQL dump
    $sql_dump = "-- SQL Dump of $table\n";
    $sql_dump .= "-- Exported: " . date("Y-m-d H:i:s") . "\n\n";
    $sql_dump .= "DROP TABLE IF EXISTS `$table`;\n";

    // Get CREATE TABLE statement
    $result = $conn->query("SHOW CREATE TABLE `$table`");
    if ($row = $result->fetch_assoc()) {
        $sql_dump .= $row['Create Table'] . ";\n\n";
    }

    // Get table data
    $data = $conn->query("SELECT * FROM `$table`");
    while ($row = $data->fetch_assoc()) {
        $columns = implode("`, `", array_keys($row));
        $values = array_map(function ($value) use ($conn) {
            return "'" . $conn->real_escape_string($value) . "'";
        }, array_values($row));
        $sql_dump .= "INSERT INTO `$table` (`$columns`) VALUES (" . implode(", ", $values) . ");\n";
    }

    // Output the SQL as file download
    header('Content-Type: application/sql');
    header("Content-Disposition: attachment; filename=\"$filename\"");
    echo $sql_dump;
    exit;
}

include "header.php";

// If passkey not set or incorrect, show passkey form
if (!isset($_SESSION['passkey']) || $_SESSION['passkey'] !== $correct_passkey) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['passkey'])) {
        if ($_POST['passkey'] === $correct_passkey) {
            $_SESSION['passkey'] = $correct_passkey;
        } else {
            echo "<p style='color: red; text-align: center;'>Incorrect passkey. Try again.</p>";
        }
    }

    if (!isset($_SESSION['passkey']) || $_SESSION['passkey'] !== $correct_passkey) {
        echo "<form method='post' style='text-align: center; margin-top: 20px;'>
                <label>Enter Passkey:</label>
                <input type='password' name='passkey' required>
                <button type='submit'>Submit</button>
              </form>";
        exit;
    }
}

// Show download button if passkey is valid
echo "<div style='text-align: center; margin-top: 50px;'>
        <h2>Email Table Export</h2><br><br>
        <form method='post'>
            <button type='submit' name='download_sql' style='padding: 10px 20px; font-size: 16px;'>Download Emails (.sql)</button>
        </form>
      </div>";
?>
