<?php
include "dbconn.php";

$orgNameFilter = isset($_GET['organizationname']) ? strtolower(trim($_GET['organizationname'])) : '';
$exactMatch = isset($_GET['exactmatch']); 

// Fetch all organizations
$sql = "SELECT organizationid, organization_name, active, merged FROM tdu_organisation WHERE merged = 0 ORDER BY organization_name ASC;";
$result = mysqli_query($conn, $sql);

$organizations = [];
while ($row = mysqli_fetch_assoc($result)) {
    $organizations[] = $row;
}

include "header.php";
$count = 0;
?>

<h1 style="margin: 20px auto; text-align: center;">Similar Organizations Report</h1>
<table class="styled-table">
    <form method="GET">
        <tr style="background-color: white;">
            <td colspan='2'>
                <input type="text" name="organizationname" value="<?= htmlspecialchars($orgNameFilter); ?>" style="width: 90%; height: 30px;" placeholder="Search Organization...">
                <input type="checkbox" name="exactmatch" <?= isset($_GET['exactmatch']) ? 'checked' : ''; ?>> Exact
            </td>
            <td>
                <button type="submit" style="width: 100%; height: 30px;"><i class="fa-solid fa-magnifying-glass"></i></button>
            </td>
        </tr>
    </form>
    <tr>
        <th>Organization Name</th>
        <th>Similar Organizations</th>
        <th style="text-align: center;">Mismatch</th>
    </tr>
    <?php foreach ($organizations as $org) : 
        if ((int) $org['active'] != 1) {
            continue;
        }
        $similar_count = 0;
        $similar_orgs = "";
        $orgNameLower = strtolower($org['organization_name']);

        // Apply filter
        if ($orgNameFilter) {
            if ($exactMatch && $orgNameLower !== $orgNameFilter) {
                continue;
            } elseif (!$exactMatch && strpos($orgNameLower, $orgNameFilter) === false) {
                continue;
            }
        }

        foreach ($organizations as $compareOrg) {
            if ($org['organizationid'] !== $compareOrg['organizationid']) {
                $dbOrgNameLower = strtolower($compareOrg['organization_name']);
                
                similar_text($org['organization_name'], $compareOrg['organization_name'], $percent);
                if ($percent > 90 || strpos($dbOrgNameLower, $orgNameLower) !== false || strpos($orgNameLower, $dbOrgNameLower) !== false) {
                    $similar_count++;
                    $orgLink = "quote.php?opt=organization-details&id=" . urlencode($compareOrg['organizationid']);
                    $similar_orgs .= " 
                        <button class='merge-btn' data-orgid='{$compareOrg['organizationid']}' data-targetid='{$org['organizationid']}'>Merge from</button> 
                        <a href='{$orgLink}' target='_blank'>" . htmlspecialchars($compareOrg['organization_name']) . "</a>
                        <br><br>";
                }
            }
        }

        if ($similar_count > 0) {
            $count++;
            if ($count > 20) {
                break;
            }
            ?>
            <tr>
                <td>
                    <a href="quote.php?opt=organization-details&id=<?php echo urlencode($org['organizationid']); ?>" target="_blank">
                        <?php echo htmlspecialchars($org['organization_name']); ?>
                    </a>
                </td>
                <td><br><?php echo $similar_orgs; ?></td>
                <td style="text-align: center;">
                    <button class="mismatch-btn" style="background-color: red;" data-orgid="<?php echo $org['organizationid']; ?>"><i class="fa-solid fa-xmark"></i></button>
                </td>
            </tr>
            <?php 
        }
        ?>
    <?php endforeach; ?>
</table>

<div style="text-align: center; ">
    <button type="button" id="reload-page-btn" style="margin-bottom: 20px; padding: 5px 10px; color: white; background-color: #334155; cursor: pointer;">Reload</button>
</div>
<script>
    document.getElementById('reload-page-btn').addEventListener('click', function() {
        location.reload();
    });
</script>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    document.querySelectorAll('.mismatch-btn').forEach(button => {
        button.addEventListener('click', function() {
            let orgId = this.getAttribute('data-orgid');
            
            if (confirm('Are you sure you want to mark this as mismatch?')) {
                fetch('1_ajax_mismatch_organization.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: 'organizationid=' + orgId
                })
                .then(response => response.text())
                .then(data => {
                    if (data === 'success') {
                        let row = this.closest('tr');
                        row.remove();
                    } else {
                        alert('Error marking organization');
                    }
                });
            }
        });
    });

    document.querySelectorAll('.merge-btn').forEach(button => {
        button.addEventListener('click', function() {
            let orgId = this.getAttribute('data-orgid');
            let targetId = this.getAttribute('data-targetid');
            
            if (confirm('Are you sure you want to merge these organizations?')) {
                fetch('ajax_merge_organisation.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: 'organization_id=' + orgId + '&target_id=' + targetId
                })
                .then(response => response.text())
                .then(data => {
                    alert(data);
                    location.reload();
                });
            }
        });
    });
    
    document.addEventListener("DOMContentLoaded", function () {
        document.querySelectorAll(".styled-table tr").forEach(row => {
            row.addEventListener("click", function () {
                this.scrollIntoView({
                    behavior: "smooth",
                    block: "center"
                });
            });
        });
    });
</script>

<style>
    .styled-table {
        border-collapse: collapse;
        width: 50%;
        margin: 20px auto;
        font-size: 16px;
        text-align: left;
    }
    .styled-table th, .styled-table td {
        padding: 12px 15px;
        border-bottom: 1px solid #ddd;
    }
    .styled-table th {
        background-color: #f9f9f9;
        color: #333;
    }
    .styled-table tr:nth-of-type(even) {
        background-color: #f9f9f9;
    }
    .styled-table tr:hover {
        background-color: lightyellow;
    }
    .styled-table th input[type="number"] {
        width: 40px;
        padding: 5px;
        margin: 0 5px;
        box-sizing: border-box;
    }
    .styled-table td input[type="number"] {
        width: 80px;
        padding: 5px;
        margin: 0 5px;
        box-sizing: border-box;
    }
    .styled-table select, .styled-table input[type="text"] {
        width: 150px;
    }
    .styled-table input[type="submit"] {
        margin: 20px 0;
        padding: 10px 20px;
        background-color: #ffbb00;
        border: none;
        color: #fff;
        font-size: 16px;
        cursor: pointer;
    }
    .styled-table input[type="submit"]:hover {
        background-color: #e0a800;
    }
    .styled-table button {
        color: white;
        background-color: #334155;
        padding: 3px 6px;
        cursor: pointer;
    }
</style>
