<?php
include "dbconn.php";
include "rezdyconn.php";

$vendorNameFilter = isset($_GET['vendorname']) ? strtolower(trim($_GET['vendorname'])) : '';
$exactMatch = isset($_GET['exactmatch']); 

// Fetch vendors from both tables
$tduSql = "SELECT vendorid AS vendor_id, vendorName, rezdy_uni_vendor FROM tdu_vendors WHERE rezdy_actioned = 0 ORDER BY vendorName ASC;";
$tduResult = mysqli_query($conn, $tduSql);
$tduVendors = [];
while ($row = mysqli_fetch_assoc($tduResult)) {
    $tduVendors[] = $row;
}

$rezdySql = "SELECT DISTINCT supplierAlias, supplierName FROM products WHERE countryCode = 'au' ORDER BY supplierName ASC;";
$rezdyResult = mysqli_query($rezdyconn, $rezdySql);
$rezdyVendors = [];
while ($row = mysqli_fetch_assoc($rezdyResult)) {
    $rezdyVendors[] = $row;
}

include "header.php";
$count = 0;
?>

<h1 style="margin: 20px auto; text-align: center;">Similar Vendors Report</h1>
<table class="styled-table">
    <form method="GET">
        <tr style="background-color: white;">
            <td colspan='2'>
                <input type="text" name="vendorname" value="<?= htmlspecialchars($vendorNameFilter); ?>" style="width: 90%; height: 30px;" placeholder="Search Vendor...">
                <input type="checkbox" name="exactmatch" <?= isset($_GET['exactmatch']) ? 'checked' : ''; ?>> Exact
            </td>
            <td>
                <button type="submit" style="width: 100%; height: 30px;"><i class="fa-solid fa-magnifying-glass"></i></button>
            </td>
        </tr>
    </form>
    <tr>
        <th>Dashboard Vendor</th>
        <th>Potential Matches in Rezdy</th>
        <th style="text-align: center;">Mismatch</th>
    </tr>
    <?php foreach ($tduVendors as $vendor): 
        $vendorNameLower = strtolower($vendor['vendorName']);

        // Apply filter
        if ($vendorNameFilter) {
            if ($exactMatch && $vendorNameLower !== $vendorNameFilter) {
                continue;
            } elseif (!$exactMatch && strpos($vendorNameLower, $vendorNameFilter) === false) {
                continue;
            }
        }

        $similarCount = 0;
        $similarVendors = "";

        foreach ($rezdyVendors as $rezdy) {
            $alias = $rezdy['supplierAlias'];
            $rezdyNameLower = strtolower($rezdy['supplierName']);

            // Skip if this alias is already linked
            if (!empty($vendor['rezdy_uni_vendor'])) {
                $linkedAliases = explode(';;', $vendor['rezdy_uni_vendor']);
                if (in_array($alias, $linkedAliases)) {
                    continue;
                }
            }

            similar_text($vendor['vendorName'], $rezdy['supplierName'], $percent);

            if ($percent > 90 || strpos($rezdyNameLower, $vendorNameLower) !== false || strpos($vendorNameLower, $rezdyNameLower) !== false) {
                $similarCount++;
                $similarVendors .= '<a href="#" class="rezdy-supplier-link" data-supplier="' . htmlspecialchars($rezdy['supplierName'], ENT_QUOTES) . '">' . htmlspecialchars($rezdy['supplierName']) . '</a> ' .
                    '<button type="button" class="link-rezdy-btn" data-vendorid="' . $vendor['vendor_id'] . '" data-alias="' . htmlspecialchars($alias) . '" style="background-color: green; color: white; padding: 2px 6px; cursor: pointer;"><i class="fa-solid fa-link"></i></button><br><br>';
            }
        }

        if ($similarCount > 0) {
            $count++;
            if ($count > 20) break;
            ?>
            <tr>
                <td>
                    <a href="quote.php?opt=vendor-details&product_active=Yes&id=<?= urlencode($vendor['vendor_id']); ?>" target="_blank">
                        <?= htmlspecialchars($vendor['vendorName']); ?>
                    </a>
                </td>
                <td><br><?= $similarVendors; ?></td>
                <td style="text-align: center;">
                    <button class="mismatch-btn" style="background-color: red;" data-vendorid="<?= $vendor['vendor_id']; ?>"><i class="fa-solid fa-xmark"></i></button>
                </td>
            </tr>
            <?php 
        }
    endforeach; ?>
</table>

<!-- link vendors -->
<script>
    document.querySelectorAll('.link-rezdy-btn').forEach(button => {
        button.addEventListener('click', function () {
            const vendorId = this.getAttribute('data-vendorid');
            const alias = this.getAttribute('data-alias');

            if (!confirm(`Are you sure you want to link them?`)) return;

            fetch('ajax_rezdy_link_vendor.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `vendorid=${encodeURIComponent(vendorId)}&alias=${encodeURIComponent(alias)}`
            })
            .then(response => response.json())
            .then(data => {
                alert(data.message);
                if (data.success) {
                    button.remove(); // Remove the button after linking
                }
            })
            .catch(err => {
                console.error('Error:', err);
                alert('An error occurred.');
            });
        });
    });

    document.querySelectorAll('.mismatch-btn').forEach(button => {
        button.addEventListener('click', function () {
            const vendorId = this.getAttribute('data-vendorid');

            if (!confirm(`Mark as Mismatch?`)) return;

            fetch('ajax_mark_vendor_actioned.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `vendorid=${encodeURIComponent(vendorId)}`
            })
            .then(response => response.json())
            .then(data => {
                alert(data.message);
                if (data.success) {
                    const row = button.closest('tr');
                    if (row) row.remove();
                }
            })
            .catch(err => {
                console.error('Error:', err);
                alert('An error occurred while marking as actioned.');
            });
        });
    });
</script>

<!-- rezdy product preview modal start -->
<div id="rezdyModal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; border: 1px solid #ccc; box-shadow: 0 2px 10px rgba(0,0,0,0.1); padding: 20px; z-index: 1000; max-height: 90vh; overflow-y: auto; width: 80%;">
    <h2 id="modalTitle" style="margin-bottom: 20px;">Rezdy Products</h2>
    <div id="modalContent">Loading...</div>
    <div style="text-align: left; margin-top: 20px;">
        <button onclick="document.getElementById('rezdyModal').style.display='none'" style="padding: 5px 10px; background-color: #334155; color: white;">Close</button>
    </div>
</div>
<script>
    document.querySelectorAll('.rezdy-supplier-link').forEach(link => {
        link.addEventListener('click', function (e) {
            e.preventDefault();
            const supplier = this.getAttribute('data-supplier');

            document.getElementById('modalTitle').textContent = 'Rezdy Products for ' + supplier;
            document.getElementById('modalContent').innerHTML = 'Loading...';
            document.getElementById('rezdyModal').style.display = 'block';

            fetch('ajax_get_rezdy_products_by_suppliername.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `supplierName=${encodeURIComponent(supplier)}`
            })
            .then(response => response.text())
            .then(html => {
                document.getElementById('modalContent').innerHTML = html;
            })
            .catch(error => {
                document.getElementById('modalContent').innerHTML = 'Error loading data.';
                console.error('Error:', error);
            });
        });
    });
</script>
<!-- rezdy product preview modal end -->

<div style="text-align: center;">
    <button type="button" id="reload-page-btn" style="margin-bottom: 20px; padding: 5px 10px; color: white; background-color: #334155; cursor: pointer;">Reload</button>
</div>
<script>
    document.getElementById('reload-page-btn').addEventListener('click', function () {
        location.reload();
    });
</script>

<style>
    .styled-table {
        border-collapse: collapse;
        width: 50%;
        margin: 20px auto;
        font-size: 16px;
        text-align: left;
    }
    .styled-table th, .styled-table td {
        padding: 12px 15px;
        border-bottom: 1px solid #ddd;
    }
    .styled-table th {
        background-color: #f9f9f9;
        color: #333;
    }
    .styled-table tr:nth-of-type(even) {
        background-color: #f9f9f9;
    }
    .styled-table tr:hover {
        background-color: lightyellow;
    }
    .styled-table th input[type="number"] {
        width: 40px;
        padding: 5px;
        margin: 0 5px;
        box-sizing: border-box;
    }
    .styled-table td input[type="number"] {
        width: 80px;
        padding: 5px;
        margin: 0 5px;
        box-sizing: border-box;
    }
    .styled-table select, .styled-table input[type="text"] {
        width: 150px;
    }
    .styled-table input[type="submit"] {
        margin: 20px 0;
        padding: 10px 20px;
        background-color: #ffbb00;
        border: none;
        color: #fff;
        font-size: 16px;
        cursor: pointer;
    }
    .styled-table input[type="submit"]:hover {
        background-color: #e0a800;
    }
    .styled-table button {
        color: white;
        background-color: #334155;
        padding: 3px 6px;
        cursor: pointer;
    }
</style>
