<?php
include "dbconn.php";

function updateAssignedSalesAgents($mysqli, $assigned_to_region, $assigned_to_external_sales_agent) {
    // Prepare the SQL query
    $sql = "UPDATE vtiger_quotes_info vqinfo
            LEFT JOIN vtiger_quotescf vqcf ON vqinfo.quoteid = vqcf.quoteid
            SET vqinfo.assigned_to_external_sales_agent = ?
            WHERE vqinfo.assigned_to_region = ? AND vqcf.cf_1162 >= CURDATE() AND vqinfo.assigned_to_external_sales_agent = '';";

    // Prepare statement
    if ($stmt = $mysqli->prepare($sql)) {
        // Bind parameters: string, string
        $stmt->bind_param("ss", $assigned_to_external_sales_agent, $assigned_to_region);

        // Execute statement
        if ($stmt->execute()) {
            echo "Updated " . $stmt->affected_rows . " rows successfully.";
        } else {
            echo "Error executing update: " . $stmt->error;
        }

        // Close statement
        $stmt->close();
    } else {
        echo "Error preparing statement: " . $mysqli->error;
    }
}

function updateAllAgents($mysqli) {
    $assignments_i = [
        "North" => "Pradeep Shukla",
        "South" => "Rohit Mokal",
        "East" => "Dhiraj Salvi",
        "West Harbour Mumbai,Solapur & Nagpur" => "Sidhikka Lotlikar",
        "West Western Mumbai, Pune & Nashik" => "Rachana Hingorani",
        "West Central Mumbai" => "Sidhikka Lotlikar"
    ];

    $assignments_e = [
        "South" => "Ajay Athith",
        "Phillippines" => "Ela Agapito",
        "East" => "Prasanta Dawn",
        "North" => "Pankaj Bisht",
        "Singapore" => "Chong",
        "West" => "Siddhesh Subhedar",
        "West Central Mumbai" => "Tausif Momin",
        "West Western Mumbai, Pune & Nashik" => "Deepesh Khot",
        "West Harbour Mumbai,Solapur & Nagpur" => "Ankita Patil"
    ];

    foreach ($assignments_e as $region => $agent) {
        updateAssignedSalesAgents($mysqli, $region, $agent);
    }
}

updateAllAgents($conn);
?>
