<?php

include "dbconn.php";  // Assumes $conn is set in dbconn.php
include "html_utility.php";  // Assumes insertRooms() is defined in html_utility.php

// Fetch quotes matching criteria
$sql = "SELECT quoteid, nsingle_room, ndouble_room, ntriple_room, children, nchild_without_bed 
        FROM vtiger_quotes 
        WHERE quote_no LIKE 'TDU3%' 
        AND quotestage IN ('Created', 'Requote')";

$result = mysqli_query($conn, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $quoteid = $row['quoteid'];
        $single_room = (int)$row['nsingle_room'];
        $double_room = (int)$row['ndouble_room'];
        $triple_room = (int)$row['ntriple_room'];
        $children = (int)$row['children'];
        $child_without_bed = (int)$row['nchild_without_bed'];
        $child_with_bed = $children - $child_without_bed;

        // Check if quoteid already exists in vtiger_pax_in_hotel
        $checkSql = "SELECT 1 FROM vtiger_pax_in_hotel WHERE quoteid = $quoteid";
        $checkResult = mysqli_query($conn, $checkSql);

        if ($checkResult && mysqli_num_rows($checkResult) == 0) {
            // QuoteID not found in vtiger_pax_in_hotel, insert rooms
            $next_seq = 1;

            $next_seq = insertRooms($conn, $quoteid, 'Single', $single_room, 0, $next_seq);
            $next_seq = insertRooms($conn, $quoteid, 'Double', $double_room, $child_without_bed, $next_seq);
            $next_seq = insertRooms($conn, $quoteid, 'Triple', $triple_room, $child_with_bed, $next_seq);

            echo "Processed quoteid: $quoteid\n";
        } else {
            echo "QuoteID $quoteid already exists in vtiger_pax_in_hotel, skipping.\n";
        }
    }
} else {
    echo "No matching quotes found.\n";
}

// Close connection if necessary (optional if handled in dbconn.php)
mysqli_close($conn);
?>
