<?php
// qbo_ajax_fetch_customer_detail.php
// AJAX worker: Fetches the raw transaction lines for a SINGLE customer.

header('Content-Type: application/json');

use QuickBooksOnline\API\DataService\DataService;
use QuickBooksOnline\API\ReportService\ReportService;

require_once __DIR__ . '/../../vendor/autoload.php';
require_once __DIR__ . '/../qbo_functions.php';
require_once __DIR__ . '/../config/qbo_config.php';
global $qboBaseConfig;

$customerId = $_GET['customer_id'] ?? null;
$startDate = $_GET['start_date'] ?? null;
$endDate = $_GET['end_date'] ?? null;

if (!$customerId || !$startDate || !$endDate) {
    echo json_encode(['error' => 'Missing required parameters.']); exit;
}

$tokenStorageFile = __DIR__ . '/../tokens/qbo_token.json';
$currentTokens = file_exists($tokenStorageFile) ? json_decode(file_get_contents($tokenStorageFile), true) : null;
if (!$currentTokens || empty($currentTokens['access_token'])) { echo json_encode(['error' => 'Auth token not found.']); exit; }

$qboBaseConfig['accessTokenKey'] = $currentTokens['access_token'];
try {
    $dataService = DataService::Configure($qboBaseConfig);
} catch (Exception $e) { echo json_encode(['error' => 'DataService config failed: ' . $e->getMessage()]); exit; }

$report = null;
try {
    $reportService = new ReportService($dataService->getServiceContext());
    $reportService->setStartDate($startDate);
    $reportService->setEndDate($endDate);
    $reportService->setCustomer($customerId);
    $report = $reportService->executeReport("CustomerSalesDetail"); // The one report name we know works with a customer filter
} catch (Exception $e) {
    echo json_encode(['error' => 'Report fetch failed: ' . $e->getMessage()]); exit;
}

echo json_encode(['success' => true, 'data' => $report]);