<?php
// qbo_ajax_fetch_sales_detail.php
// FINAL WORKER: Accepts accounting_method and returns clean JSON data.

header('Content-Type: application/json');

use QuickBooksOnline\API\DataService\DataService;
use QuickBooksOnline\API\ReportService\ReportService;

require_once __DIR__ . '/../../vendor/autoload.php';
require_once __DIR__ . '/../qbo_functions.php';
require_once __DIR__ . '/../config/qbo_config.php';
global $qboBaseConfig;

// Get parameters from the AJAX request
$customerId = $_GET['customer_id'] ?? null;
$startDate = $_GET['start_date'] ?? null;
$endDate = $_GET['end_date'] ?? null;
$accountingMethod = $_GET['accounting_method'] ?? 'Accrual'; // Added this parameter

if (!$customerId || !$startDate || !$endDate) {
    echo json_encode(['error' => 'Missing required parameters.']); exit;
}

// Token and Connection Logic
$tokenStorageFile = __DIR__ . '/../tokens/qbo_token.json';
$currentTokens = file_exists($tokenStorageFile) ? json_decode(file_get_contents($tokenStorageFile), true) : null;
if (!$currentTokens || empty($currentTokens['access_token'])) { echo json_encode(['error' => 'Auth token not found.']); exit; }

$qboBaseConfig['accessTokenKey'] = $currentTokens['access_token'];
try { $dataService = DataService::Configure($qboBaseConfig); } catch (Exception $e) { echo json_encode(['error' => 'DataService config failed: ' . $e->getMessage()]); exit; }

$report = null;
try {
    $reportService = new ReportService($dataService->getServiceContext());
    $reportService->setStartDate($startDate);
    $reportService->setEndDate($endDate);
    $reportService->setCustomer($customerId);
    $reportService->setAccountingMethod($accountingMethod); // Use the new parameter
    $report = $reportService->executeReport("CustomerSalesDetail");
} catch (Exception $e) {
    echo json_encode(['error' => 'Report fetch failed for customer ' . $customerId . ': ' . $e->getMessage()]); exit;
}

echo json_encode(['success' => true, 'data' => $report]);