<?php
// qbo_reports.php
// CORRECTED: Restored all links, fixed include paths, and fixed CSS overlap issue.

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();

if (!isset($_SESSION['user_name']) || $_SESSION['title'] != 'admin') {
    header('Location: login.php');
    exit;
}

$reportType = isset($_GET['report']) ? $_GET['report'] : null;

$pageTitle = "QBO Reports";
if ($reportType === 'ap') { $pageTitle = "QBO A/P Ageing Report"; } 
elseif ($reportType === 'ar') { $pageTitle = "QBO A/R Ageing Report"; } 
elseif ($reportType === 'pl_by_month') { $pageTitle = "QBO P&L Report"; } 
elseif ($reportType === 'income_by_customer') { $pageTitle = "Income by Customer Summary"; }
elseif ($reportType === 'sales_by_customer_detail') { $pageTitle = "Sales by Customer Detail"; }
elseif ($reportType === 'sales_revenue') { $pageTitle = "Sales & Revenue Report"; }
elseif ($reportType === 'supplier_cost') { $pageTitle = "Supplier Cost Report"; }
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($pageTitle); ?></title>
    <style>
        body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif; background-color: #f0f2f5; margin: 0; }
        .main-content { margin-left: 250px; padding: 20px; transition: margin-left 0.3s; }
        /* MODIFIED: Added padding-top to the main content area */
        .report-header { padding-top: 60px; }
        .report-header h2, .report-header h3 { margin-bottom: 5px; color: #333; } .report-header p { margin-top: 0; color: #666; }
        .filter-form { background-color: #fff; padding: 15px; margin-bottom: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); display: flex; gap: 15px; align-items: center; flex-wrap: wrap; }
        .filter-form label { font-weight: 500; color: #555; }
        .filter-form input, .filter-form select { padding: 8px 12px; border: 1px solid #ccc; border-radius: 4px; }
        .filter-form button { background-color: #0866c3; color: white; padding: 8px 15px; border: none; border-radius: 4px; cursor: pointer; font-weight: bold; }
        table { border-collapse: collapse; width: 100%; margin-bottom: 30px; background-color: #fff; box-shadow: 0 2px 4px rgba(0,0,0,0.1); border-radius: 8px; overflow: hidden; }
        th, td { border: 1px solid #ddd; padding: 10px 12px; text-align: left; }
        th { background-color: #f7f7f7; color: #555; font-weight: 600; }
        td.currency, th.currency { text-align: right; }
        .total-row td, tfoot td { font-weight: bold; background-color: #f2f2f2; border-top: 2px solid #ccc; }
        .sidebar { height: 100%; width: 250px; position: fixed; z-index: 1; top: 0; left: 0; background-color: #343a40; overflow-x: hidden; transition: 0.3s; padding-top: 20px; }
        .sidebar-header { padding: 10px 15px; text-align: center; font-size: 1.2em; color: #f8f9fa; border-bottom: 1px solid #495057; margin-bottom: 10px;}
        .sidebar a { padding: 10px 15px; text-decoration: none; font-size: 1.1em; color: #adb5bd; display: block; transition: 0.2s; border-radius: 4px; margin: 2px 10px; }
        .sidebar a:hover, .sidebar a.active { color: #f8f9fa; background-color: #495057; }
        .open-btn { font-size: 20px; cursor: pointer; background-color: #343a40; color: white; padding: 10px 15px; border: none; position: fixed; top: 15px; left: 15px; z-index: 2; border-radius: 5px;}
        body.sidebar-open .main-content { margin-left: 250px; } body.sidebar-closed .main-content { margin-left: 0; }
        body.sidebar-closed .sidebar { width: 0; }
        .no-data-message { text-align: center; padding: 20px; color: #555; font-style: italic; }
        .sub-row td { background-color: #fafafa; padding-left: 40px !important; }
    </style>
</head>
<body class="sidebar-open">
    <nav id="mySidebar" class="sidebar">
        <div class="sidebar-header"><strong>QBO Reports</strong></div>
        <a href="?report=pl_by_month" class="<?php echo ($reportType === 'pl_by_month' ? 'active' : ''); ?>">Profit & Loss</a>
        <a href="?report=sales_revenue" class="<?php echo ($reportType === 'sales_revenue' ? 'active' : ''); ?>">Sales & Revenue</a>
        <a href="?report=income_by_customer" class="<?php echo ($reportType === 'income_by_customer' ? 'active' : ''); ?>">Income by Customer</a>
        <a href="?report=sales_by_customer_detail" class="<?php echo ($reportType === 'sales_by_customer_detail' ? 'active' : ''); ?>">Sales by Customer Detail</a>
        <a href="?report=supplier_cost" class="<?php echo ($reportType === 'supplier_cost' ? 'active' : ''); ?>">Supplier Cost Report</a>
        <hr style="border-color: #495057; margin: 10px;">
        <a href="?report=ar" class="<?php echo ($reportType === 'ar' ? 'active' : ''); ?>">A/R Ageing</a>
        <a href="?report=ap" class="<?php echo ($reportType === 'ap' ? 'active' : ''); ?>">A/P Ageing</a>
    </nav>
    <div id="main" class="main-content">
        <button class="open-btn" onclick="toggleNav()">☰ Menu</button>
        <?php
        if ($reportType === 'ap') { include 'qbo_ap_ageing_report.php'; } 
        elseif ($reportType === 'ar') { include 'qbo_ar_ageing_report.php'; } 
        elseif ($reportType === 'pl_by_month') { include 'qbo_pl_by_month_report.php'; }
        elseif ($reportType === 'income_by_customer') { include 'qbo_income_by_customer_report.php'; }
        elseif ($reportType === 'income_by_customer_detail') { include 'qbo_income_by_customer_detail_report.php'; } // This was previously incorrect
        elseif ($reportType === 'sales_by_customer_detail') { include 'qbo_sales_by_customer_detail_report.php'; }
        elseif ($reportType === 'sales_revenue') { include 'qbo_sales_revenue_report.php'; }
        elseif ($reportType === 'supplier_cost') { include 'qbo_supplier_cost_report.php'; } 
        else {
            echo '<div class="report-header"><h2>Welcome to QuickBooks Online Reports</h2></div>';
            echo '<p class="no-data-message">Please select a report from the menu to get started.</p>';
        }
        ?>
    </div>
    <script>
        function toggleNav() { document.body.classList.toggle('sidebar-open'); document.body.classList.toggle('sidebar-closed'); }
        document.addEventListener('DOMContentLoaded', function() { if (window.innerWidth <= 768) { document.body.classList.add('sidebar-closed'); } else { document.body.classList.add('sidebar-open'); } });
    </script>
</body>
</html>