<?php
// qbo_income_by_customer_detail_report.php
// FINAL VERSION: Standalone detail report using the correct API name.

use QuickBooksOnline\API\DataService\DataService;
use QuickBooksOnline\API\ReportService\ReportService;

require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../qbo_functions.php';
require_once __DIR__ . '/../config/qbo_config.php';
global $qboBaseConfig;

if (!function_exists('getQBOTransactionLink')) { function getQBOTransactionLink($txnId, $txnType, $baseUrl) { if (empty($txnId)) return '#'; $isSandbox = (strcasecmp($baseUrl, 'Development') == 0); $qboDomain = $isSandbox ? "https://app.sandbox.qbo.intuit.com/app/" : "https://app.qbo.intuit.com/app/"; $page = strtolower(str_replace(' ', '', $txnType)); if (in_array($page, ['invoice', 'salesreceipt', 'creditmemo', 'payment'])) { return $qboDomain . $page . "?txnId=" . htmlspecialchars($txnId); } return '#'; } }

$customerId = isset($_GET['customer_id']) ? $_GET['customer_id'] : null;
$customerName = isset($_GET['customer_name']) ? $_GET['customer_name'] : 'N/A';
$startDate = isset($_GET['start_date']) ? $_GET['start_date'] : date('Y-m-d', strtotime('-1 year'));
$endDate = isset($_GET['end_date']) ? $_GET['end_date'] : date('Y-m-d');

$dataService = null; $report = null;

if (!$customerId) { exit("Error: Customer ID is required to run this report."); }

$tokenStorageFile = __DIR__ . '/../tokens/qbo_token.json';
$currentTokens = file_exists($tokenStorageFile) ? json_decode(file_get_contents($tokenStorageFile), true) : null;
if ($currentTokens && !empty($currentTokens['access_token'])) {
    $qboBaseConfig['accessTokenKey'] = $currentTokens['access_token'];
    try { $dataService = DataService::Configure($qboBaseConfig); } catch (Exception $e) { $dataService = null; }
}

$reportFetchSuccess = false;
if ($dataService) {
    try {
        $reportName = "CustomerSalesDetail"; // Correct report name confirmed by test
        $reportService = new ReportService($dataService->getServiceContext());
        $reportService->setStartDate($startDate);
        $reportService->setEndDate($endDate);
        $reportService->setCustomer($customerId);
        $report = $reportService->executeReport($reportName);
        if ($report) { $reportFetchSuccess = true; }
    } catch (Exception $e) { /* Suppress error */ }
}
?>

<div class="report-header">
    <p><a href="?report=income_by_customer&start_date=<?php echo $startDate; ?>&end_date=<?php echo $endDate; ?>">« Back to Summary</a></p>
    <h2>Sales by Customer Detail</h2>
    <h3><?php echo htmlspecialchars($customerName); ?></h3>
    <p>For period: <?php echo htmlspecialchars(date("F j, Y", strtotime($startDate))) . " - " . htmlspecialchars(date("F j, Y", strtotime($endDate))); ?> </p>
</div>

<table>
    <thead><tr><?php if($report) { foreach($report->Columns->Column as $column) { echo "<th>" . htmlspecialchars($column->ColTitle) . "</th>"; } } ?></tr></thead>
    <tbody>
        <?php
        if ($reportFetchSuccess && isset($report->Rows->Row)) {
            $rows = is_array($report->Rows->Row) ? $report->Rows->Row : [$report->Rows->Row];
            foreach ($rows as $row) {
                if (isset($row->Header) && isset($row->Rows->Row)) {
                    $dataRows = is_array($row->Rows->Row) ? $row->Rows->Row : [$row->Rows->Row];
                    foreach($dataRows as $dataRow) {
                        if (isset($dataRow->type) && $dataRow->type == 'Data') {
                            echo "<tr>";
                            foreach($dataRow->ColData as $idx => $cell) {
                                $cellValue = htmlspecialchars($cell->value ?? '');
                                if ($idx === 1) {
                                    $txnId = $cell->id ?? null; $link = getQBOTransactionLink($txnId, $cellValue, $qboBaseConfig['baseUrl']);
                                    echo "<td><a href='{$link}' target='_blank'>{$cellValue}</a></td>";
                                } else { echo "<td>{$cellValue}</td>"; }
                            }
                            echo "</tr>";
                        }
                    }
                }
                if (isset($row->Summary->ColData)) {
                    echo '<tr class="total-row">';
                    foreach($row->Summary->ColData as $cell) { echo "<td><strong>" . htmlspecialchars($cell->value) . "</strong></td>"; }
                    echo '</tr>';
                }
            }
        } else { echo '<tr><td colspan="9" class="no-data-message">No sales data found for this customer.</td></tr>'; }
        ?>
    </tbody>
     <tfoot>
        <?php
        if ($reportFetchSuccess && isset($report->Summary) && !isset($report->Summary->ColData)) {
             $lastRow = end($report->Rows->Row);
             if (isset($lastRow->Summary->ColData) && (isset($lastRow->group) && $lastRow->group === 'GrandTotal')) {
                 echo '<tr class="total-row">';
                 foreach ($lastRow->Summary->ColData as $cell) { echo "<td><strong>" . htmlspecialchars($cell->value) . "</strong></td>"; }
                 echo '</tr>';
             }
        }
        ?>
    </tfoot>
</table>