<?php
require 'dbconn.php';

session_start();

// Redirect to login page if not logged in
if (!isset($_SESSION['user_name'])) {
    header('Location: login.php');
    exit;
}

$username = $_SESSION['user_name'];
$sql_ajax = "SELECT CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users WHERE user_name = '$username';";
$result_ajax = mysqli_query($conn, $sql_ajax);
$created_by = '';
if(mysqli_num_rows($result_ajax) > 0) {
    $row_ajax = $result_ajax->fetch_assoc();
    $created_by = $row_ajax['name'];
}

$response = ['success' => false];

$fields = [
    'organizationid',
    'visit_time',
    'mode',
    'designation',
    'contact_person',
    'contact_no',
    'contact_email',
    'current_ito',
    'meeting_notes',
    'action',
    'next_follow_up_date'
];

$data = [];
foreach ($fields as $field) {
    $data[$field] = isset($_POST[$field]) ? trim($_POST[$field]) : null;
}

$stmt = $conn->prepare("
    INSERT INTO tdu_organisation_followup (
        organizationid, visit_time, mode, designation,
        contact_person, contact_no, contact_email,
        current_ito, meeting_notes, action,
        next_follow_up_date, created_by
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
");

if ($stmt) {
    $stmt->bind_param(
        "ssssssssssss",
        $data['organizationid'],
        $data['visit_time'],
        $data['mode'],
        $data['designation'],
        $data['contact_person'],
        $data['contact_no'],
        $data['contact_email'],
        $data['current_ito'],
        $data['meeting_notes'],
        $data['action'],
        $data['next_follow_up_date'],
        $created_by
    );

    if ($stmt->execute()) {
        $response['success'] = true;
    } else {
        $response['error'] = "Database insert failed: " . $stmt->error;
    }

    $stmt->close();
} else {
    $response['error'] = "Failed to prepare statement.";
}

echo json_encode($response);
?>
