<?php
include 'dbconn.php'; 
session_start();

$created_by = $_SESSION['user_name']; 

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $quoteid = $_POST['quoteid'] ?? '';
    if (empty($quoteid)) {
        echo "Invalid request";
        exit();
    }

    $category = $conn->real_escape_string($_POST['category']);
    $subcategory = isset($_POST['subcategory']) ? $conn->real_escape_string($_POST['subcategory']) : '';
    $notes = $conn->real_escape_string($_POST['notes']);
    $attachment_path = '';

    if (isset($_FILES['attachment']) && $_FILES['attachment']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = 'note_attachments/';
        $originalName = pathinfo($_FILES['attachment']['name'], PATHINFO_FILENAME);
        $fileExt = pathinfo($_FILES['attachment']['name'], PATHINFO_EXTENSION);
        $timestamp = date('YmdHis');
        $safeName = preg_replace('/[^a-zA-Z0-9_-]/', '_', $originalName);
        $newFileName = $safeName . '-' . $timestamp . '.' . $fileExt;
        $uploadPath = $uploadDir . $newFileName;

        // Create the folder if it doesn't exist
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0775, true);
        }

        if (move_uploaded_file($_FILES['attachment']['tmp_name'], $uploadPath)) {
            $attachment_path = $conn->real_escape_string($uploadPath);
        } else {
            echo "File upload failed.";
            exit();
        }
    }

    $sql = "INSERT INTO vtiger_notes (quoteid, category, subcategory, notes, created_by, attachment_path) VALUES (?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssssss", $quoteid, $category, $subcategory, $notes, $created_by, $attachment_path);

    if ($stmt->execute()) {
        echo "success";
    } else {
        echo "Error: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();
} else {
    echo "Invalid request";
}
?>
