<?php
include 'dbconn.php';

$region = trim($_POST['cc_region']);
$email = trim($_POST['cc_email']);
$type = isset($_POST['cc_type']) ? trim($_POST['cc_type']) : '';
$auto_id = isset($_POST['auto_id']) ? intval($_POST['auto_id']) : 0;

if ($region !== '' && $email !== '' && $type !== '') {
    if ($auto_id > 0) {
        // Update existing entry
        $stmt = $conn->prepare("UPDATE tdu_email_auto_cc SET region = ?, email = ?, email_type = ? WHERE auto_id = ?");
        $stmt->bind_param("sssi", $region, $email, $type, $auto_id);
        $stmt->execute();
        echo "Updated successfully.";
    } else {
        // Insert new entry
        $stmt = $conn->prepare("INSERT INTO tdu_email_auto_cc (region, email, email_type) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $region, $email, $type);
        $stmt->execute();
        echo "Added successfully.";
    }
} else {
    echo "Region, email, and email type are required.";
}
?>
