<?php
include "dbconn.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get the posted form data
    $newOrg = $_POST['organization'];
    $auto_ids = json_decode($_POST['auto_ids'], true); // Decode the JSON string to get the auto_ids

    if (!$newOrg || empty($auto_ids)) {
        echo "Error: Missing data.";
        exit;
    }

    foreach ($auto_ids as $auto_id) {
        // Fetch the current region value
        $query = "SELECT region FROM tdu_auto_assign_rules WHERE auto_id = $auto_id";
        $result = mysqli_query($conn, $query);
        
        if (!$result) {
            echo "Error fetching region: " . mysqli_error($conn);
            exit;
        }

        $row = mysqli_fetch_assoc($result);
        $currentRegion = $row['region'];

        // Append the new organization, ensuring no duplicates
        $updatedRegion = $currentRegion ? $currentRegion . ";;" . $newOrg : $newOrg;
        $updatedRegion = implode(";;", array_unique(explode(";;", $updatedRegion))); // Remove duplicates

        // Update the region field
        $updateSql = "UPDATE tdu_auto_assign_rules SET region = '$updatedRegion' WHERE auto_id = $auto_id";

        if (!mysqli_query($conn, $updateSql)) {
            echo "Error updating region: " . mysqli_error($conn);
            exit;
        }
    }

    echo "Organization added successfully!";
    mysqli_close($conn);
}
?>
