<?php
include "dbconn.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $regionToDelete = $_POST['region'] ?? null;
    $auto_ids = isset($_POST['auto_ids']) ? json_decode($_POST['auto_ids'], true) : null;

    if (!$regionToDelete || !$auto_ids || !is_array($auto_ids)) {
        echo "Error: Missing or invalid data.";
        exit;
    }

    foreach ($auto_ids as $auto_id) {
        // Fetch current region data
        $query = "SELECT region FROM tdu_auto_assign_rules WHERE auto_id = $auto_id";
        $result = mysqli_query($conn, $query);

        if (!$result) {
            echo "Error fetching region for ID $auto_id: " . mysqli_error($conn);
            continue;
        }

        $row = mysqli_fetch_assoc($result);
        $regions = explode(";;", $row['region']);

        // Remove the selected region
        $updatedRegions = array_filter($regions, fn($r) => trim($r) !== trim($regionToDelete));
        $newRegionString = implode(";;", $updatedRegions);

        // Update the database
        $updateQuery = "UPDATE tdu_auto_assign_rules SET region = '$newRegionString' WHERE auto_id = $auto_id";

        if (!mysqli_query($conn, $updateQuery)) {
            echo "Error updating record for ID $auto_id: " . mysqli_error($conn);
        }
    }

    echo "Organization removed successfully!";
    mysqli_close($conn);
}
?>
