<?php
include 'dbconn.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $quote_no = isset($data['quote_no']) ? $data['quote_no'] : null;
    $status = isset($data['status']) ? $data['status'] : null;
    $tag_id = isset($data['tag']) ? $data['tag'] : null;
    $delete_tag_id = isset($data['delete_tag']) ? $data['delete_tag'] : null;
    $conversations = $data['conversations'];

    if (!empty($conversations)) {
        foreach ($conversations as $conversation_id) {
            // Skip empty conversation IDs
            if (empty($conversation_id)) {
                continue;
            }

            // Sanitize inputs
            $conversation_id_safe = mysqli_real_escape_string($conn, $conversation_id);
            $fields = [];
            $updates = [];

            // Handle quote_no
            if (!empty($quote_no)) {
                $quote_no_safe = mysqli_real_escape_string($conn, $quote_no);
                $fields[] = "quote_no = '$quote_no_safe'";
                $updates[] = "quote_no = '$quote_no_safe'";
            }

            // Handle status
            if (!empty($status)) {
                $status_safe = mysqli_real_escape_string($conn, $status);
                $fields[] = "status = '$status_safe'";
                $updates[] = "status = '$status_safe'";

                $fields[] = "status_updated_at = NOW()";
                $updates[] = "status_updated_at = NOW()";
            }

            // Update vtiger_support table (quote_no/status)
            if (!empty($fields)) {
                $sql = "INSERT INTO vtiger_support (ticketid, " . implode(", ", array_map(function ($f) {
                        return explode(" = ", $f)[0];
                    }, $fields)) . ")
                        VALUES ('$conversation_id_safe', " . implode(", ", array_map(function ($f) {
                        return explode(" = ", $f)[1];
                    }, $fields)) . ")
                        ON DUPLICATE KEY UPDATE " . implode(", ", $updates);

                mysqli_query($conn, $sql);
            }

            // Handle tag insertion into vtiger_freetagged_objects (Add Tag)
            if (!empty($tag_id)) {
                $tag_id_safe = mysqli_real_escape_string($conn, $tag_id);

                $tag_sql = "INSERT IGNORE INTO vtiger_freetagged_objects (object_id, tag_id, tagged_on, module) 
                            VALUES ('$conversation_id_safe', '$tag_id_safe', NOW(), 'Dashboard')";
                mysqli_query($conn, $tag_sql);
            }

            // Handle tag deletion from vtiger_freetagged_objects (Delete Tag)
            if (!empty($delete_tag_id)) {
                $delete_tag_id_safe = mysqli_real_escape_string($conn, $delete_tag_id);

                $delete_tag_sql = "DELETE FROM vtiger_freetagged_objects 
                                   WHERE object_id = '$conversation_id_safe' 
                                   AND tag_id = '$delete_tag_id_safe'";
                mysqli_query($conn, $delete_tag_sql);
            }
        }

        echo json_encode(['success' => true]);
    } else {
        http_response_code(400);
        echo json_encode(['error' => 'Invalid input.']);
    }
}
?>
