<?php
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    include 'dbconn.php';

    $data = json_decode(file_get_contents('php://input'), true);
    $organizationIds = $data['organizationIds'];
    $category = (int)$data['category'];

    if (!empty($organizationIds) && $category > 0) {
        $placeholders = implode(',', array_fill(0, count($organizationIds), '?'));
        $sql = "UPDATE tdu_organisation SET preferred = ? WHERE organizationid IN ($placeholders)";
        $stmt = $conn->prepare($sql);
        $types = str_repeat('i', count($organizationIds) + 1);
        $params = array_merge([$category], $organizationIds);
        $stmt->bind_param($types, ...$params);
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Organisation categories updated successfully.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to update organisation categories.']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid data.']);
    }
}
?>
