<?php
include "dbconn.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'];
    $newPassword = $_POST['newPassword'];

    if (empty($newPassword)) {
        echo json_encode(['status' => 'error', 'message' => 'Password cannot be empty.']);
        exit;
    }

    // Generate a random password (if necessary, you can adjust this part for a more secure password policy)
    // For example, if using a randomly generated password, you could use something like:
    // $newPassword = substr(str_shuffle('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()_+-=[]{}|;:,.<>?'), 0, 12);

    // Format password to match the existing MD5 crypt format
    $salt = '$1$' . substr(str_shuffle('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, 2) . '000000$';
    $hashedPassword = crypt($newPassword, $salt);

    // Update the password in the database
    $stmt = $conn->prepare("UPDATE vtiger_users SET user_password = ? WHERE id = ?");
    $stmt->bind_param("si", $hashedPassword, $id);

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Password updated successfully.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update password.']);
    }

    $stmt->close();
    $conn->close();
}
?>
