<?php
// ajax_chatbot.php (Chatbot API File - Handles POST Requests)
require_once "ai_keys.php";

function promptGeminiAI_chat($prompt)
{
    $apiUrl = apiURL_Flash2(); // Ensure this endpoint supports grounding (e.g., Gemini 1.5 or 2.0 models) [1, 5]

    // Construct the payload with the 'tools' parameter for grounding
    $payload = [
        'contents' => [
            [
                'parts' => [
                    ['text' => $prompt]
                ]
            ]
        ],
        'tools' => [ // Add this 'tools' array to enable grounding [5]
            [
                'googleSearch' => new stdClass() // Add the googleSearch tool; new stdClass() creates an empty JSON object {} [5]
            ]
        ],
        'generationConfig' => [
            'temperature' => 0.3  // Set temperature to 0.3
        ]
        // Optional: Add 'tool_config' for dynamic retrieval (see explanation below)
        /*
        ,'tool_config' => [
            'retrieval_config' => [
                'retrieval_strategy' => 'GOOGLE_SEARCH', // Explicitly state strategy
                'disable_attribution' => false,          // Keep attribution links (default) [5]
                'dynamic_retrieval' => [
                    'mode' => 'AUTO', // Or 'MANUAL' [5]
                    // 'threshold' => 0.5 // Optional: Adjust threshold (default 0.3) [5, 6]
                ]
            ]
        ]
        */
    ];

    $headers = [
        'Content-Type: application/json'
    ];

    $ch = curl_init($apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if (curl_errno($ch)) {
        echo "cURL Error: " . curl_error($ch) . "\n";
        curl_close($ch); // Close curl handle on error
        return null; // Indicate failure
    } else {
        curl_close($ch); // Close curl handle after execution
        if ($httpCode == 200) {
            $responseData = json_decode($response, true);
            // IMPORTANT: The response structure changes with grounding.
            // You'll need to parse 'groundingMetadata' or similar fields. [3, 15]
            // The primary text might still be in 'candidates'[0]['content']['parts'][0]['text']
            // but you also get grounding sources and search queries. [2, 5]

            if (isset($responseData['candidates'][0]['content']['parts'][0]['text'])) {
                $responseText = $responseData['candidates'][0]['content']['parts'][0]['text'];
                //var_dump($responseText);
                // Your existing string cleaning
                $responseText = str_replace("```json", "", $responseText);
                $responseText = str_replace("```", "", $responseText);
                $responseText = trim($responseText);
                
                // Case-insensitive check: Does it start with 'html'? (stripos)
                if (stripos($responseText, 'html') === 0) {
                     // Remove the first 4 characters ('html')
                     $responseText = substr($responseText, 4);
                     // Trim any leading whitespace that might have been after 'html'
                     $responseText = ltrim($responseText);
                }
                // You might want to return the full $responseData
                // so you can access grounding info in the calling code.
                // For now, just returning the text as before:
                return $responseText . "\n";

            } else {
                 // Log or print the response structure if the expected text path isn't found
                 // echo "Unexpected response structure:\n";
                 // print_r($responseData);
                 return "Could not extract text from response.\n";
            }
        } else {
            echo "API Error: HTTP Code " . $httpCode . "\n";
            echo "API Response:\n";
            echo $response . "\n"; // Show the raw error response from the API
            return "API Key might be invalid, quota exceeded, or grounding configuration issue. Check the error details.\n";
        }
    }
}

function getBotResponse(string $message): string {
    session_start();
    if (!isset($_SESSION['chat_history'])) {
        $_SESSION['chat_history'] = [];
    }
    $_SESSION['chat_history'][] = ['role' => 'user', 'message' => $message];

    $max_history_length = 10; // Keep only the last 10 turns
    if (count($_SESSION['chat_history']) > $max_history_length) {
        array_shift($_SESSION['chat_history']); // Remove the oldest turn
    }

    // Build prompt with conversation history
    //$prompt = "You are a helpful chatbot with an extremely thick Australian accent.  Here is the conversation history so far:\n\n";
    $prompt = "Here what you need to remember:
        1. You are an incredibly helpful AI, try to give as detailed of an advice as possible
        2. Your response will be displayed in HTML keep that in mind as you respond to keep the formatting coherent
        3. Do not use any formatting that will break HTML
        4. Response with HTML formatting if necessary
        5. Do not start with 'Bot: ' or any of the sort for under any circumstances unless requested by the user
        6. Have the space between paragraphs to be 15px
        7. Absolutely avoid using asterisks (*) for any formatting or emphasis AT ALL COST, if you have to use a list use the html for a list instead (Double check after you're done writing your response, remember cause you keep forgetting)
        8. analyse the response again once immediately before returning it, to double check if any rules are broken.
        . Here is the conversation history so far:\n\n";
    foreach ($_SESSION['chat_history'] as $turn) {
        $prompt .= ucfirst($turn['role']) . ": " . $turn['message'] . "\n";
    }
    $prompt .= "\nNow, answer the latest user message as a helpful AI would immediately:";


    $response = promptGeminiAI_chat($prompt);

    // Add bot response to chat history
    $_SESSION['chat_history'][] = ['role' => 'bot', 'message' => $response];

    return $response;
}

if ($_SERVER["REQUEST_METHOD"] == "POST") { // **Handles POST requests**
    $chatbotMessage = $_POST["message"] ?? ''; // Get message from $_POST
    if (!empty($chatbotMessage)) {
        $response = getBotResponse($chatbotMessage);
        echo $response;
    }
    exit();
}
?>