<?php
include 'dbconn.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['organizationName'])) {
    $orgName = trim($_POST['organizationName']);
    $orgNameLower = strtolower($orgName);

    $query = "SELECT organizationid, organization_name FROM tdu_organisation";
    $result = mysqli_query($conn, $query);

    $similarIds = [];

    while ($row = mysqli_fetch_assoc($result)) {
        $dbOrgNameLower = strtolower($row['organization_name']);

        if (trim($dbOrgNameLower) == '') {
            continue;
        }
        
        // Check substring relationship
        if (strpos($dbOrgNameLower, $orgNameLower) !== false || strpos($orgNameLower, $dbOrgNameLower) !== false) {
            $similarIds[] = $row['organizationid'];
            continue;
        }
        
        // Check similarity
        similar_text($orgNameLower, $dbOrgNameLower, $percentage);
        if ($percentage > 85) {
            $similarIds[] = $row['organizationid'];
        }
    }

    echo json_encode([
        'exists' => !empty($similarIds),
        'similar_ids' => $similarIds
    ]);

    mysqli_close($conn);
}
?>
