<?php
include "dbconn.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $userName = $_POST['user_name'];
    $firstName = $_POST['first_name'];
    $lastName = $_POST['last_name'];
    $title = $_POST['title'];

    // Generate a random password
    $newPasswordPlain = substr(str_shuffle('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, 12);

    // Format password to match the existing MD5 crypt format
    $salt = '$1$' . substr(str_shuffle('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'), 0, 2) . '000000$';
    $hashedPassword = crypt($newPasswordPlain, $salt);

    // Insert user into the database
    $stmt = $conn->prepare("INSERT INTO vtiger_users (user_name, first_name, last_name, title, user_password, status) VALUES (?, ?, ?, ?, ?, 'Active')");
    $stmt->bind_param("sssss", $userName, $firstName, $lastName, $title, $hashedPassword);

    if ($stmt->execute()) {
        // Get the new auto id
        $newUserId = $conn->insert_id;

        // Prepare data for vtiger_freetags
        $tag = $firstName . ' ' . $lastName;
        $rawTag = 'person';
        $visibility = 'public';
        $owner = $newUserId;

        // Insert into vtiger_freetags table
        $stmtTag = $conn->prepare("INSERT INTO vtiger_freetags (tag, raw_tag, visibility, owner) VALUES (?, ?, ?, ?)");
        $stmtTag->bind_param("sssi", $tag, $rawTag, $visibility, $owner);

        if ($stmtTag->execute()) {
            // Return the plain-text new password
            echo $newPasswordPlain;
        } else {
            echo "Error inserting into vtiger_freetags: " . $stmtTag->error;
        }

        $stmtTag->close();
    } else {
        echo "Error creating user: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();
}
?>
