<?php
include 'dbconn.php';

// Use plain text instead of JSON if needed
$use_json = false; // Change to false to return plain text

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['auto_id'])) {
    $auto_id = intval($_POST['auto_id']); // Secure the input

    // Prepare and execute the DELETE statement
    $sql = "DELETE FROM tdu_template_products WHERE auto_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $auto_id);

    if ($stmt->execute()) {
        $response = $use_json ? json_encode(["success" => true]) : "success";
    } else {
        $response = $use_json ? json_encode(["success" => false, "message" => "Error deleting record."]) : "Error deleting record.";
    }

    // Close connections
    $stmt->close();
    $conn->close();
} else {
    $response = $use_json ? json_encode(["success" => false, "message" => "Invalid request."]) : "Invalid request.";
}

// Set the correct response header
if ($use_json) {
    header('Content-Type: application/json');
}

echo $response;
exit;
?>
