<?php
header('Content-Type: application/json');
session_start();
include "dbconn.php";
include "dictionaries.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $key = $input['delete_key'] ?? '';

    if ($key) {
        list($quoteid, $productid, $sequence_no) = explode('_', $key);
        $quoteid = mysqli_real_escape_string($conn, $quoteid);
        $productid = mysqli_real_escape_string($conn, $productid);
        $sequence_no = mysqli_real_escape_string($conn, $sequence_no);

        try {
            $conn->autocommit(false); // Begin transaction

            recordDeleteConfirmedProductHistory($conn, $quoteid, $sequence_no);
            $queries = getSqlTableToDeleteQuoteProducts($quoteid, $sequence_no);

            foreach ($queries as $query) {
                if (!$conn->query($query)) {
                    throw new Exception($conn->error);
                }
            }

            // Track deletion
            $productname = getProductByProductID($conn)[$productid];
            $productname = mysqli_real_escape_string($conn, $productname);
            $username = $_SESSION['user_name'];
            $trackQuery = "INSERT INTO vtiger_quote_stage_track (quoteid, user_name, stage, created_at) 
                           VALUES ('$quoteid', '$username', 'Delete Product: $productname', NOW())";
            if (!$conn->query($trackQuery)) {
                throw new Exception($conn->error);
            }

            $conn->commit();
            echo json_encode(['success' => true]);
        } catch (Exception $e) {
            $conn->rollback();
            echo json_encode(['success' => false, 'error' => $e->getMessage()]);
        } finally {
            $conn->close();
        }
    } else {
        echo json_encode(['success' => false, 'error' => 'Invalid delete key.']);
    }
} else {
    echo json_encode(['success' => false, 'error' => 'Invalid request method.']);
}
