<?php
header('Content-Type: application/json');
include 'dbconn.php';

$quoteId = $_POST['quoteid'] ?? '';
$vendorId = $_POST['vendorid'] ?? '';
$filePath = $_POST['filepath'] ?? '';

if (empty($quoteId) || empty($vendorId) || empty($filePath)) {
    echo json_encode(['success' => false, 'message' => 'Missing quoteid, vendorid, or filepath']);
    exit;
}

// Sanitize inputs
$quoteId = mysqli_real_escape_string($conn, $quoteId);
$vendorId = mysqli_real_escape_string($conn, $vendorId);
$filePath = mysqli_real_escape_string($conn, $filePath);

// Get current invoice_path from DB
$sql = "SELECT invoice_path FROM vtiger_supplier_payment 
        WHERE quoteid = '$quoteId' AND vendorid = '$vendorId' LIMIT 1";

$result = mysqli_query($conn, $sql);

if (!$result || mysqli_num_rows($result) === 0) {
    echo json_encode(['success' => false, 'message' => 'Invoice not found in database']);
    exit;
}

$row = mysqli_fetch_assoc($result);
$currentPaths = explode(',', $row['invoice_path']);
$updatedPaths = [];

// Normalize file paths and remove the one we're deleting
foreach ($currentPaths as $path) {
    if (trim($path) !== trim($filePath)) {
        $updatedPaths[] = trim($path);
    }
}

// Delete the physical file
// $realPath = realpath($filePath);
// if ($realPath && file_exists($realPath)) {
//     if (!unlink($realPath)) {
//         echo json_encode(['success' => false, 'message' => 'Failed to delete file from disk']);
//         exit;
//     }
// } else {
//     // File may have already been deleted, continue to update DB
// }

// Update DB with new paths
$newPathStr = implode(',', $updatedPaths);
$updateSql = "UPDATE vtiger_supplier_payment 
              SET invoice_path = '" . mysqli_real_escape_string($conn, $newPathStr) . "' 
              WHERE quoteid = '$quoteId' AND vendorid = '$vendorId'";

if (mysqli_query($conn, $updateSql)) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => mysqli_error($conn)]);
}
?>
