<?php
// ajax request to display in summary -> Document -> Display Sale Order

include 'dbconn.php';

session_start();

// Redirect to login page if not logged in
if (!isset($_SESSION['user_name'])) {
    header('Location: login.php');
    exit;
}
$username = $_SESSION['user_name'];
$title = $_SESSION['title'] ?? '';
$department = $_SESSION['department'] ?? '';

if (isset($_GET['quoteid'])) {
    $quoteid = $_GET['quoteid'];

    $sql = "SELECT auto_id, day, tour_time, event_name FROM vtiger_itinerary_new_event
            WHERE quoteid='$quoteid'
            ORDER BY day ASC, tour_time ASC;";
    $result = mysqli_query($conn, $sql);
    $eventsArray = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $day = $row['day'];
        if (!isset($eventsArray[$day])) {
            $eventsArray[$day] = [];
        }
        $eventsArray[$day][] = [
            'auto_id' => $row['auto_id'],
            'tour_time' => $row['tour_time'],
            'event_name' => $row['event_name']
        ];
    }
    
    $sql = "SELECT cf_1162 FROM vtiger_quotescf WHERE quoteid='$quoteid' LIMIT 1;";
    $result = mysqli_query($conn, $sql);
    
    $date_of_travel = null;
    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        if (isset($row['cf_1162']) && !empty($row['cf_1162'])) {
            $date_of_travel = $row['cf_1162'];
        }
    }
    
    $sql = "SELECT vp.productname, vp.description, vi.sequence_no, vdo.display_order AS display_order, vi.day, vi.comment, vi.cf_928, vi.tourtime, tv.address, tv.locationPhone
            FROM vtiger_inventoryproductrel vi
            LEFT JOIN vtiger_display_order vdo ON vi.id=vdo.id AND vi.sequence_no=vdo.sequence_no
            LEFT JOIN (
                SELECT productid, productname, unit_price, 'true' AS customised, vendor_id, '' AS description FROM vtiger_products_custom
                UNION ALL
                SELECT productid, productName AS productname, unitPrice AS unit_price, '' AS customised, vendorid AS vendor_id, description FROM tdu_products
            ) vp ON vi.productid = vp.productid
            LEFT JOIN tdu_vendors tv ON vi.vendorid=tv.vendorid
            WHERE vi.id='$quoteid' AND vi.show_in_so = 1

            UNION ALL

            SELECT 
                product_field AS productname, 
                '' AS description, 
                (1000+auto_id) AS sequence_no, 
                (1000+auto_id) AS display_order, 
                day_field AS day, 
                remark AS comment, 
                cf_928,
                '' AS tourtime,
                '' AS address,
                '' AS locationPhone
            FROM vtiger_invoice_add_products
            WHERE quoteid='$quoteid'

            ORDER BY 
                day ASC,
                CASE 
                    WHEN tourtime IS NULL OR tourtime = '' THEN 1
                    ELSE 0
                END ASC,
                tourtime ASC,
                display_order ASC, 
                sequence_no ASC;";
    $result = mysqli_query($conn, $sql);

    $hotels = [];
    $others = [];
    while ($row = mysqli_fetch_assoc($result)) {
        if ($row['cf_928'] === 'Hotel') {
            $sequence_no = $row['sequence_no'];
        
            // List of keys to retrieve
            $meta_keys = [
                'check_in',
                'check_out',
                'confirmation_number',
                'single_rooms',
                'double_rooms',
                'triple_rooms'
            ];
        
            // Convert to comma-separated quoted values for SQL
            $keys_in = "'" . implode("','", $meta_keys) . "'";
        
            $sql_meta = "SELECT meta_key, meta_value FROM vtiger_itinerary 
                         WHERE quoteid='$quoteid' 
                         AND sequence_no='$sequence_no' 
                         AND meta_key IN ($keys_in)
                         ORDER BY created_at DESC;";
        
            $result_meta = mysqli_query($conn, $sql_meta);
        
            // Initialize values
            $meta_data = [];
        
            if ($result_meta && mysqli_num_rows($result_meta) > 0) {
                while ($meta_row = mysqli_fetch_assoc($result_meta)) {
                    // Only assign if not already set (first/latest entry)
                    if (!isset($meta_data[$meta_row['meta_key']])) {
                        $meta_data[$meta_row['meta_key']] = $meta_row['meta_value'];
                    }
                }
            }
        
            // Merge into original row
            $row = array_merge($row, $meta_data);
        
            $hotels[] = $row;
        } else {
            $others[] = $row;
        }
    }
    if($hotels == []) {
        $sql_self_booked_hotels = "SELECT auto_id, hotel_name AS productname, city, checkin_date AS check_in, checkout_date AS check_out 
                                    FROM tdu_self_booked_hotels WHERE quoteid = '$quoteid'";
        $result_self_booked_hotels = mysqli_query($conn, $sql_self_booked_hotels);
        while ($row = mysqli_fetch_assoc($result_self_booked_hotels)) {
            $row['productname'] .= ' (Self-Booked)';
            $hotels[] = $row;
        }
    }
    
    // Start HTML Table
    echo '<table class="display-so-table" style="width: 50%;" border="1" cellspacing="1" cellpadding="2">';
    echo "<tr><td colspan='5' style='text-align: right;'>Itinerary ID: {$quoteid}</td></tr>";
    
    $currentDay = null;
    $sequenceCount = [];
    $usedEvents = [];
    foreach ($others as $row) {
        if ($currentDay !== $row['day']) {
            if (!empty($currentDay) && isset($eventsArray[$currentDay])) {
                foreach ($eventsArray[$currentDay] as $event) {
                    if (!in_array($event['auto_id'], $usedEvents)) {
                        ?>
                        <tr>
                            <td><?= htmlspecialchars($event['tour_time']) ?></td>
                            <td><?php echo htmlspecialchars($event['event_name']); ?></strong></td>
                        </tr>
                        <?php
                        $usedEvents[] = $event['auto_id']; // Mark event as used
                    }
                }
            }
            $currentDay = $row['day'];
            
            // Calculate the date if travel date is set
            if (isset($date_of_travel) && $date_of_travel != '') {
                $date = date('d F Y, l', strtotime($date_of_travel . ' + ' . ($row['day'] - 1) . ' days'));
                foreach ($hotels as $hotel) {
                    $check_date = date('Y-m-d', strtotime($date_of_travel . ' + ' . ($row['day'] - 2) . ' days'));
        
                    if ($check_date >= $hotel['check_in'] && $check_date <= date('Y-m-d', strtotime($hotel['check_out'] . ' -1 day'))) {
                        echo "<tr><td>Stay At</td>";
                        
                        $itemName = $hotel['productname'] ?? '';
                        $itemName = str_replace('&', 'and', $itemName);
                        echo "<td>$itemName";
                    
                        // Room Details
                        $roomDetails = [];
                        if (!empty($hotel['single_rooms']) && (int)$hotel['single_rooms'] > 0) {
                            $roomDetails[] = "{$hotel['single_rooms']} Single Room";
                        }
                        if (!empty($hotel['double_rooms']) && (int)$hotel['double_rooms'] > 0) {
                            $roomDetails[] = "{$hotel['double_rooms']} Double Room";
                        }
                        if (!empty($hotel['triple_rooms']) && (int)$hotel['triple_rooms'] > 0) {
                            $roomDetails[] = "{$hotel['triple_rooms']} Triple Room";
                        }

                        // Confirmation Number
                        if (!empty($hotel['confirmation_number']) || !empty($roomDetails)) {
                            echo "<br>";
                            if (!empty($hotel['confirmation_number'])) {
                                echo "<br>Confirmation Number: {$hotel['confirmation_number']}";
                            }
                        
                            if (!empty($roomDetails)) {
                                echo "<br>" . implode(', ', $roomDetails);
                            }
                        }
                    
                        // Address and Phone
                        if (!empty($hotel['address'])) {
                            echo "<br>Address: {$hotel['address']}";
                        }
                        if (!empty($hotel['locationPhone'])) {
                            echo "<br>Phone: {$hotel['locationPhone']}";
                        }
                    
                        echo "</td></tr>";
                    }
                }
            } else {
                $date = '';
            }
            echo "<tr><td colspan='5'><strong>Day {$currentDay} - {$date}</strong></td></tr>";
        }

        $sequence_no = $row['sequence_no'];
        if (!isset($sequenceCount[$sequence_no])) {
            $sequenceCount[$sequence_no] = 0;
        }
        $sequenceCount[$sequence_no]++;
        $sub_seq_no = ($sequenceCount[$sequence_no] - 1) * 10000;
        $remaining = $sequence_no;
        $sequence_no += $sub_seq_no;

        $sqlMeta = "
            SELECT t1.meta_key, t1.meta_value
            FROM vtiger_itinerary AS t1
            INNER JOIN (
                SELECT meta_key, MAX(created_at) AS max_created_at
                FROM vtiger_itinerary
                WHERE quoteid = '$quoteid'
                AND sequence_no = '$remaining'
                AND (sub_seq_no = '$sub_seq_no' OR sub_seq_no IS NULL)
                GROUP BY meta_key
            ) AS t2
            ON t1.meta_key = t2.meta_key 
            AND t1.created_at = t2.max_created_at
            WHERE t1.quoteid = '$quoteid'
            AND t1.sequence_no = '$remaining'
            AND (t1.sub_seq_no = '$sub_seq_no' OR t1.sub_seq_no IS NULL)
            GROUP BY t1.meta_key;
        ";
        $resultMeta = mysqli_query($conn, $sqlMeta);
        
        $adults = $children = $infants = $tour_manager = null;
        $otherMeta = [];
        $adults = $children = $infants = $tour_manager = $tourtime = '';
        while ($metaRow = mysqli_fetch_assoc($resultMeta)) {
            $metaKey = $metaRow['meta_key'];
            $metaValue = $metaRow['meta_value'];
        
            if ($metaKey === 'adults') {
                $adults = $metaValue;
            } elseif ($metaKey === 'children') {
                $children = $metaValue;
            } elseif ($metaKey === 'infants') {
                $infants = $metaValue;
            } elseif ($metaKey === 'tour_manager') {
                $tour_manager = $metaValue;
            } elseif ($metaKey === 'tourtime') {
                $tourtime = $metaValue;
            } else {
                $otherMeta[$metaKey] = $metaValue;
            }
        }

        if (!empty($currentDay) && isset($eventsArray[$currentDay])) {
            foreach ($eventsArray[$currentDay] as $event) {
                if (!in_array($event['auto_id'], $usedEvents) && (empty($tourtime) || $event['tour_time'] < $tourtime)) {
                    ?>
                    <tr>
                        <td><?= htmlspecialchars($event['tour_time']) ?></td>
                        <td><?php echo htmlspecialchars($event['event_name']); ?></strong></td>
                    </tr>
                    <?php
                    $usedEvents[] = $event['auto_id']; // Mark event as used
                }
            }
        }

        if (isset($otherMeta['transfer_option'])) {
            if ($otherMeta['transfer_option'] == 'a') {
                unset($otherMeta['pickup_location']);
                unset($otherMeta['dropoff_location']);
            } elseif ($otherMeta['transfer_option'] == 'b') {
                unset($otherMeta['hourly_charter']);
                unset($otherMeta['driver_name']);
                unset($otherMeta['driver_contact']);
            } else {
                unset($otherMeta['pickup_location']);
                unset($otherMeta['dropoff_location']);
                unset($otherMeta['hourly_charter']);
                unset($otherMeta['driver_name']);
                unset($otherMeta['driver_contact']);
            }
        } else {
            unset($otherMeta['payment_deadline']);
            unset($otherMeta['cancellation_deadline']);
            unset($otherMeta['booking_status']);
        }
        
        $fieldsToShow = [];
        // if (!empty($adults) && (int) $adults > 0) {
        //     $fieldsToShow[] = "Adults: $adults";
        // }
        // if (!empty($children) && (int) $children > 0) {
        //     $fieldsToShow[] = "Children: $children";
        // }
        // if (!empty($infants) && (int) $infants > 0) {
        //     $fieldsToShow[] = "Infants: $infants";
        // }
        // if (!empty($tour_manager) && (int) $tour_manager > 0) {
        //     $fieldsToShow[] = "Tour Manager: $tour_manager";
        // }

        $itemName = $row['productname'] ?? '';
        $itemName = str_replace('&', 'and', $itemName);
        
        $comment = str_replace('&', 'and', $row['comment']);
        $comment = nl2br($comment);

        $details = implode(', ', $fieldsToShow);
        foreach ($otherMeta as $key => $value) {
            if($key == 'transfer_option' || $key == 'booking_status' || $key == 'payment_status' || $value == '' || $value == 0) {
                continue;
            }
            $key = str_replace('_', ' ', $key);
            $key = ucwords($key);
            $details .= "<br>$key: $value";
        }
        
        echo "<tr>";
        if($row['cf_928'] == 'Hotel') {
            echo "<td></td>";
        } else {
            echo "<td>" . ($tourtime ? $tourtime : '') . "</td>";
        }
        echo "<td>$itemName";
        if($comment || $details || !empty($row['address']) || !empty($row['locationPhone'])) {
            echo "<br>";
        }
        if($comment) {
            echo "<br>Comments: $comment";
        }
        if($details) {
            echo "$details";
        }

        // Address and Phone
        if (!empty($row['address'])) {
            echo "<br>Address: {$row['address']}";
        }
        if (!empty($row['locationPhone'])) {
            echo "<br>Phone: {$row['locationPhone']}";
        }

        $sql_flight_details = "SELECT flight_number, from_city, to_city, from_datetime, to_datetime FROM tdu_flight_details WHERE quoteid='$quoteid' AND sequence_no='$sequence_no';";
        $result_flight_details = mysqli_query($conn, $sql_flight_details);
        if ($result_flight_details && mysqli_num_rows($result_flight_details) > 0) {
            $flight = mysqli_fetch_assoc($result_flight_details);
            
            echo "<br><br>Flight Number: " . htmlspecialchars($flight['flight_number']);
            echo "<br>From: " . htmlspecialchars($flight['from_city']) . " at " . date('d M Y, h:i A', strtotime($flight['from_datetime']));
            echo "<br>To: " . htmlspecialchars($flight['to_city']) . " at " . date('d M Y, h:i A', strtotime($flight['to_datetime']));
        }
        
        echo "</td>";
        echo "</tr>";
    }

    $query = "SELECT adults, children, infants FROM vtiger_quotes WHERE quoteid = '$quoteid'";
    $result = mysqli_query($conn, $query);

    if ($row = mysqli_fetch_assoc($result)) {
        $adults = $row['adults'];
        $children = $row['children'];
        $infants = $row['infants'];
        $tour_manager = $row['tour_manager'];

        // Prepare details to display
        $fieldsToShow = [];
        if (!empty($adults) && (int) $adults > 0) {
            $fieldsToShow[] = "Adults: $adults";
        }
        if (!empty($children) && (int) $children > 0) {
            $fieldsToShow[] = "Children: $children";
        }
        if (!empty($infants) && (int) $infants > 0) {
            $fieldsToShow[] = "Infants: $infants";
        }

        // Join the array into a string and display it
        $details = implode(', ', $fieldsToShow);
        echo "<tr><td colspan='5' style='text-align: right;'>{$details}</td></tr>";
    }

    echo '</table>';
}
?>

<style>
    .display-so-table td{
        padding: 10px;
    }
</style>
