<?php
require_once("dbconn.php");

$quoteid = $_GET['quoteid'] ?? '';
if (!$quoteid) {
    http_response_code(400);
    exit("Missing quoteid");
}

header("Content-Type: text/csv");
header("Content-Disposition: attachment; filename=quote_products.csv");
header("Pragma: no-cache");
header("Expires: 0");

$output = fopen("php://output", "w");

// Step 1: Get pax ranges for Transfers (subquoteid > 1)
$pax_ranges = [];
$pax_range_headers = [];

$sql_pax = "SELECT DISTINCT pax_min, pax_max, subquoteid
            FROM vtiger_products_saleprice
            WHERE quoteid='$quoteid' AND subquoteid > 1
            ORDER BY pax_min ASC";
$result_pax = mysqli_query($conn, $sql_pax);
if ($result_pax) {
    while ($row_pax = mysqli_fetch_assoc($result_pax)) {
        $range_label = "Pax: " . $row_pax['pax_min'] . "-" . $row_pax['pax_max'];
        $pax_ranges[$row_pax['subquoteid']] = $range_label;
        $pax_range_headers[] = $range_label;
    }
}

// Step 2: Write CSV header
$header = ['Day', 'Travel Date', 'Category', 'Product Name', 'Description', 'Adult', 'Child', 'Infant'];
$header = array_merge($header, $pax_range_headers); // Add dynamic pax headers
fputcsv($output, $header);

// Step 3: Get travel date if needed (not used here, just retained)
$sql = "SELECT cf_1162 FROM vtiger_quotescf WHERE quoteid = '$quoteid'";
$result = $conn->query($sql);
if ($result && $row = $result->fetch_assoc()) {
    $travel_date = $row['cf_1162'];
}

// Step 4: Get main product data
$sql = "SELECT 
            vi.sequence_no, vi.day, vi.cf_928, vp.productname, vi.comment, vp.description, 
            IFNULL(vps.sale_price, '') AS sale_price, 
            IFNULL(vps.sale_price_child, '') AS sale_price_child, 
            IFNULL(vps.sale_price_infant, '') AS sale_price_infant
        FROM (SELECT * FROM vtiger_quotes WHERE quoteid='$quoteid') vq
        LEFT JOIN vtiger_inventoryproductrel vi ON vq.quoteid=vi.id
        LEFT JOIN (
            SELECT productid, productname, '' AS description FROM vtiger_products_custom
            UNION ALL
            SELECT productid, productName AS productname, description FROM tdu_products
        ) vp ON vi.productid=vp.productid
        LEFT JOIN vtiger_products_saleprice vps 
            ON vq.quoteid = vps.quoteid 
            AND vi.sequence_no = vps.sequence_no 
            AND vps.subquoteid <= 1
        ORDER BY vi.sequence_no ASC";

$result = $conn->query($sql);
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $adjusted_date = '';
        if (!empty($travel_date) && isset($row['day'])) {
            $date = new DateTime($travel_date);
            $days_to_add = (int)$row['day'] - 1;
            $date->modify("+$days_to_add days");
            $adjusted_date = $date->format('Y-m-d');
        }

        $base_data = [
            $row['cf_928'] == 'Hotel' ? '' : $row['day'],
            $row['cf_928'] == 'Hotel' ? '' : $adjusted_date,
            $row['cf_928'],
            $row['productname'],
            trim($row['comment'] . " " . $row['description']),
            $row['sale_price'] == 0 ? '' : $row['sale_price'],
            $row['sale_price_child'] == 0 ? '' : $row['sale_price_child'],
            $row['sale_price_infant'] == 0 ? '' : $row['sale_price_infant']
        ];

        $pax_prices = [];

        // Step 5: If Transfers, get prices for all pax ranges
        if (strtolower($row['cf_928']) === 'transfers') {
            foreach ($pax_ranges as $subquoteid => $label) {
                $sub_sql = "SELECT sale_price 
                            FROM vtiger_products_saleprice 
                            WHERE quoteid = '$quoteid' 
                            AND sequence_no = '{$row['sequence_no']}' 
                            AND subquoteid = '$subquoteid' 
                            LIMIT 1";
                $sub_result = $conn->query($sub_sql);
                if ($sub_result && $sub_row = $sub_result->fetch_assoc()) {
                    $pax_prices[] = $sub_row['sale_price'];
                } else {
                    $pax_prices[] = ''; // empty if not found
                }
            }
        } else {
            // Not a transfer, leave blank columns
            $pax_prices = array_fill(0, count($pax_ranges), '');
        }

        // Combine and output row
        $final_row = array_merge($base_data, $pax_prices);
        fputcsv($output, $final_row);
    }
} else {
    fputcsv($output, ['Error executing main query']);
}

fclose($output);
$conn->close();
exit;
?>
