<?php
include "dbconn.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get JSON input
    $data = json_decode(file_get_contents('php://input'), true);

    if (!isset($data['template_id'])) {
        echo json_encode(['success' => false, 'message' => 'Invalid input']);
        exit;
    }

    // Sanitize input
    $template_id = (int) $data['template_id'];

    // Fetch the template details
    $sql = "SELECT * FROM tdu_templates WHERE templateid = $template_id";
    $result = mysqli_query($conn, $sql);

    if ($row = mysqli_fetch_assoc($result)) {
        // Remove primary key field
        unset($row['templateid']);

        // Modify name to indicate duplication (if 'templatename' field exists)
        if (isset($row['templatename'])) {
            $row['templatename'] .= " - copy";
        }

        // Prepare column names and values dynamically
        $columns = implode(", ", array_keys($row));
        $values = implode(", ", array_map(function ($value) use ($conn) {
            return "'" . mysqli_real_escape_string($conn, $value) . "'";
        }, array_values($row)));

        // Insert duplicate template
        $insert_sql = "INSERT INTO tdu_templates ($columns) VALUES ($values)";
        if (mysqli_query($conn, $insert_sql)) {
            $new_template_id = mysqli_insert_id($conn); // Get new template ID

            // Duplicate related template products
            $product_sql = "SELECT * FROM tdu_template_products WHERE templateid = $template_id";
            $product_result = mysqli_query($conn, $product_sql);

            while ($product = mysqli_fetch_assoc($product_result)) {
                unset($product['auto_id']); // Remove primary key
                unset($product['created_at']); // Remove primary key

                // Assign new template ID to duplicated products
                $product['templateid'] = $new_template_id;

                // Prepare column names and values dynamically
                $product_columns = implode(", ", array_keys($product));
                $product_values = implode(", ", array_map(function ($value) use ($conn) {
                    return "'" . mysqli_real_escape_string($conn, $value) . "'";
                }, array_values($product)));

                // Insert duplicate product record
                $product_insert_sql = "INSERT INTO tdu_template_products ($product_columns) VALUES ($product_values)";
                mysqli_query($conn, $product_insert_sql);
            }

            echo json_encode(['success' => true, 'message' => 'Template and associated products duplicated successfully!']);
        } else {
            echo json_encode(['success' => false, 'message' => mysqli_error($conn)]);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Template not found']);
    }
}
?>
