<?php
include 'dbconn.php';
include 'html_utility.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['productid'], $_POST['newDate'])) {
    $productid = mysqli_real_escape_string($conn, $_POST['productid']);
    $newDate = mysqli_real_escape_string($conn, $_POST['newDate']); // Expected format: YYYY-MM-DD

    $row = fetchDynamicPrice($conn, $productid, $newDate);

    if ($row) {
        echo json_encode([
            'success' => true,
            'unitPrice' => $row['unitPrice'],
            'childPrice' => $row['childPrice'],
            'infantPrice' => $row['infantPrice'],
            'sharingPrice' => $row['sharingPrice'],
            'triplePrice' => $row['triplePrice'],
            'childWithBedPrice' => $row['childWithBedPrice'],
            'childNoBedPrice' => $row['childNoBedPrice']
        ]);
    } else {
        echo json_encode(['success' => false, 'message' => 'No price data found']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
}

mysqli_close($conn);
?>
