<?php
include 'dbconn.php';

if (isset($_GET['id'])) {
    $aiRefId = intval($_GET['id']);
    $sql = "SELECT id, templateref FROM tdu_temp_ai_quotes WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $aiRefId);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        // Explode by comma
        $values = explode(',', $row['templateref']);
        
        // Remove "N/A" values
        $filteredValues = array_filter($values, function ($value) {
            return trim($value) !== "N/A";
        });

        // Implode back to a string
        $cleanedTemplateRef = implode(',', $filteredValues);

        echo json_encode(["success" => true, "templateref" => $cleanedTemplateRef]);
    } else {
        echo json_encode(["success" => false]);
    }
    $stmt->close();
}
?>
