<?php
include 'dbconn.php';

session_start();

// Redirect to login page if not logged in
if (!isset($_SESSION['user_name'])) {
    header('Location: login.php');
    exit;
}

$disable_approve = 'disabled';
if ($_SESSION['title'] == 'admin') {
    $disable_approve = '';
}

if (isset($_POST['quoteid']) && isset($_POST['sequence_no'])) {
    $quoteid = $_POST['quoteid'];
    $sequence_no = $_POST['sequence_no'];

    // Query to fetch vendor details and associated price information
    $sql = "SELECT tpa.auto_id AS tpavid, tpa.productnamecustom, tpa.vendornamecustom, tpa.vendorid,
                   tpa.price1, tpa.price2, tpa.price3, tpa.category, tpa.actioned, tpa.approved
            FROM tdu_product_alt_vendors_in_quote tpa
            WHERE tpa.quoteid = '$quoteid' AND tpa.sequence_no = '$sequence_no'";

    $result = mysqli_query($conn, $sql);
    $output = "";

    while ($row = mysqli_fetch_assoc($result)) {
        if ((int) $row['actioned'] == 1) {
            $disable_approve = 'disabled';
        } else if ($_SESSION['title'] == 'admin') {
            $disable_approve = '';
        }

        // Retrieve prices for each vendor or set to empty if not found
        $price1 = isset($row['price1']) && $row['price1'] != '' ? '$' . $row['price1'] : '';
        $price2 = isset($row['price2']) && $row['price2'] != '' ? '$' . $row['price2'] : '';
        $price3 = isset($row['price3']) && $row['price3'] != '' ? '$' . $row['price3'] : '';

        if ($price1 == '') {
            $disable_approve = 'disabled';
        }

        // Check if vendorid is 0 and show "Create New Vendor" button
        if ($row['vendorid'] == 0 && $row['approved'] == 1) {
            $vendor_action = "<button type='button' class='create-alt-vendor-btn' onclick=\"window.open('quote.php?opt=add-new-vendors&tpavid={$row['tpavid']}', '_blank'); document.getElementById('altVendorModal').style.display = 'none';\">
                                Create Vendor
                              </button>
                              <button type='button' class='revert-alt-price-btn' data-tpavid='{$row['tpavid']}' style='background-color: red;'>
                                Void Approval
                              </button>";
        } else {
            $vendor_action = "<button type='button' class='save-alt-price-btn' data-tpavid='{$row['tpavid']}' $disable_approve>
                                <i class='fa-solid fa-check'></i>
                              </button>";
        }

        $custom_vendor_icon = '';
        if ($row['vendorid'] == 0) {
            $custom_vendor_icon = '<i class="fa-solid fa-pen-ruler"></i>';
        }

        // Create a table row with three price input fields
        $output .= "<tr>
                        <td style='padding: 10px; text-align: left;'>{$row['productnamecustom']}</td>
                        <td style='padding: 10px; text-align: left;'>{$custom_vendor_icon} {$row['vendornamecustom']}</td>
                        <td style='padding: 10px; text-align: left;'>{$price1}</td>
                        <td style='padding: 10px; text-align: left;'>{$price2}</td>
                        <td style='padding: 10px; text-align: left;'>{$price3}</td>
                        <td style='padding: 10px; text-align: center;'>{$vendor_action}</td>
                    </tr>";
    }

    // Add "Reject All" button if vendors are found
    if ($output != "") {
        $output = "
            <tr>
                <td colspan='6' style='text-align: right; padding: 10px;'>
                    <button type='button' class='reject-all-alt-btn' data-quoteid='{$quoteid}' data-sequence_no='{$sequence_no}' style='background-color: red; color: white; width: 100%; border: none;'>
                        Reject All
                    </button>
                </td>
            </tr>" . $output;
    }

    // Display Save button if vendors are found
    if ($output == "") {
        $output = "<tr><td colspan='6' style='text-align: center; padding: 10px;'>No alternative vendors found.</td></tr>";
    }

    echo $output;
}
?>
