<?php
include 'dbconn.php';

$productNameFilter = isset($_GET['productname']) ? $_GET['productname'] : '';
$vendorNameFilter = isset($_GET['vendorname']) ? $_GET['vendorname'] : '';
$categoryFilter = isset($_GET['category']) ? $_GET['category'] : '';
$cityFilter = isset($_GET['city']) ? $_GET['city'] : '';

// Base query
$productid = isset($_GET['productid']) ? $_GET['productid'] : '';
$sql = "SELECT p.productid, p.productName, v.vendorName, p.category, p.city, p.keywords 
        FROM tdu_products p
        LEFT JOIN tdu_vendors v ON p.vendorid = v.vendorid
        ";
if($productid != '') {
    $sql .= " WHERE NOT EXISTS (
                SELECT 1 
                FROM tdu_products_associated pa
                WHERE pa.productid = $productid AND pa.associated = p.productid
            ) AND v.vendorActive = 'Yes' AND p.productActive = 'Yes'";
} else {
    $sql .= " WHERE 1=1 AND v.vendorActive = 'Yes' AND p.productActive = 'Yes' ";
}

// Apply filters
if ($productNameFilter) {
    $sql .= " AND CONCAT(p.productName, p.keywords) LIKE '%" . $conn->real_escape_string($productNameFilter) . "%'";
}
if ($vendorNameFilter) {
    $sql .= " AND v.vendorName LIKE '%" . $conn->real_escape_string($vendorNameFilter) . "%'";
}
if ($categoryFilter) {
    $sql .= " AND p.category LIKE '%" . $conn->real_escape_string($categoryFilter) . "%'";
}
if ($cityFilter) {
    $sql .= " AND p.city LIKE '%" . $conn->real_escape_string($cityFilter) . "%'";
}

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * 20;
$sql .= " LIMIT 20 OFFSET $offset";
$result = $conn->query($sql);
?>

<?php if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) { ?>
        <tr>
            <td style="text-align: left;"><?php echo htmlspecialchars($row['productName']); ?></td>
            <td style="text-align: left;"><?php echo htmlspecialchars($row['vendorName']); ?></td>
            <td style="text-align: left;"><?php echo htmlspecialchars($row['category']); ?></td>
            <td style="text-align: left;"><?php echo htmlspecialchars($row['city']); ?></td>
            <td style="text-align: left;"><?php echo htmlspecialchars($row['keywords']); ?></td>
            <td style="text-align: left;">
                <button class="associate-btn" data-productid="<?php echo $row['productid']; ?>"><i class="fa-solid fa-link"></i></button>
            </td>
        </tr>
    <?php }
} else { ?>
    <tr>
        <td colspan="6">No More records</td>
    </tr>
<?php } ?>
