<?php
include 'dbconn.php';

if (isset($_GET['parentid'])) {
    $parentid = intval($_GET['parentid']);
    $vendorNameFilter = $_GET['vendorNameFilter'] ?? '';
    $categoryFilter = $_GET['categoryFilter'] ?? '';
    $cityFilter = $_GET['cityFilter'] ?? '';
    $countryFilter = $_GET['countryFilter'] ?? '';
    $activeFilter = $_GET['activeFilter'] ?? '';

    $sql = "SELECT 
                p.productid,
                p.productName,  
                v.vendorName, 
                v.vendorid, 
                p.category, 
                p.city, 
                p.keywords, 
                p.preferred, 
                p.featured, 
                p.productActive, 
                v.vendorCountry, 
                CASE 
                    WHEN p.category = 'Hotel' THEN p.sharingPrice 
                    ELSE p.unitPrice 
                END AS price,
                CASE 
                    WHEN p.category = 'Hotel' THEN p.triplePrice 
                    ELSE p.childPrice 
                END AS child_price
            FROM tdu_products p
            LEFT JOIN tdu_vendors v ON p.vendorid=v.vendorid  
            WHERE v.vendorActive = 'Yes' AND p.parentid = ?";
    if ($vendorNameFilter) {
        $sql .= " AND v.vendorName LIKE '%" . $conn->real_escape_string($vendorNameFilter) . "%'";
    }
    if ($categoryFilter) {
        $sql .= " AND p.category LIKE '%" . $conn->real_escape_string($categoryFilter) . "%'";
    }
    if ($cityFilter) {
        $sql .= " AND p.city LIKE '%" . $conn->real_escape_string($cityFilter) . "%'";
    }
    if ($countryFilter) {
        $sql .= " AND v.vendorCountry LIKE '%" . $conn->real_escape_string($countryFilter) . "%'";
    }
    if ($activeFilter) {
        $sql .= " AND p.productActive LIKE '%" . $conn->real_escape_string($activeFilter) . "%'";
    }

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $parentid);
    $stmt->execute();
    $result = $stmt->get_result();

    $childProducts = [];
    while ($row = $result->fetch_assoc()) {
        $childProducts[] = $row;
    }

    echo json_encode($childProducts);
}
?>
