<?php
include "dbconn.php";

$quoteid = $_GET['quoteid'] ?? '';
$vendorid = $_GET['vendorid'] ?? '';
$so = 'SO001';

if (!$quoteid || !$vendorid || !$so) {
    echo json_encode(['status' => 'error', 'message' => 'Missing quoteid']);
    exit;
}

$sql = "SELECT DISTINCT vi.day FROM vtiger_inventoryproductrel vi
        LEFT JOIN tdu_products tp ON vi.productid=tp.productid
        WHERE vi.id='$quoteid' AND tp.vendorid='$vendorid';";
$result = mysqli_query($conn, $sql);

$days = [];
while ($row = mysqli_fetch_assoc($result)) {
    $days[] = $row['day'];
}
$daysString = implode(',', $days);

// Call export_quote.php to generate the document
// $url = 'https://dev.yourbestwayhome.com.au/turtledownunder/export_quote.php';
$url = 'https://dashboard.turtledownunder.com.au/export_quote.php';

// Use cURL to get the file content
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, [
    'quoteid' => $quoteid,
    'so' => $so,
    'vendor_transfers_days' => $daysString
]);
$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo json_encode(['status' => 'error', 'message' => curl_error($ch)]);
    curl_close($ch);
    exit;
}

$contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
curl_close($ch);

if (strpos($contentType, 'application/vnd.openxmlformats-officedocument.wordprocessingml.document') === false) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid file type received']);
    exit;
}

// Save to tmp_itinerary folder
$timestamp = date('YmdHis');
$fileName = "ITINERARY-{$quoteid}-{$timestamp}.docx";
$filePath = __DIR__ . "/tmp_itinerary/" . $fileName;

if (!file_put_contents($filePath, $response)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to save file']);
    exit;
}

// Return the file path (relative for the browser)
echo json_encode([
    'status' => 'success',
    'fileName' => $fileName,
    'fileUrl' => "tmp_itinerary/{$fileName}" // You can change to full URL if necessary
]);

?>

