<?php
// ajax_fetch_quote.php
// FINAL CORRECTED - Fetches a full DETAIL LIST of quotes filtered by TRAVEL DATE for frontend aggregation.

header('Content-Type: application/json');
include "dbconn.php"; // Include your standard database connection.

// --- Get Parameters ---
$start_date = $_GET['start_date'] ?? null;
$end_date = $_GET['end_date'] ?? null;

if (!$start_date || !$end_date) {
    echo json_encode(['success' => false, 'error' => 'Missing start_date or end_date parameter.']);
    exit;
}

if (!$conn) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed.']);
    exit;
}

$response_data = ['success' => true, 'data' => []];

try {
    // This script fetches all necessary details for each quote within the travel date range.
    // The frontend will handle all filtering and aggregation.
    
    // --- Subquery to get the first, non-deleted version of a quote ---
    $unique_quotes_subquery = "(
        SELECT inner_vq.quoteid, inner_vq.quotestage, inner_vq.no_pax, inner_vq.country, inner_vq.contactid
        FROM vtiger_quotes inner_vq
        WHERE inner_vq.quoteid = (
            SELECT MIN(sub.quoteid) FROM vtiger_quotes AS sub WHERE sub.quote_no = inner_vq.quote_no AND sub.deleted = 0
        )
    ) vq";

    // --- Main Query to fetch a detailed list for frontend processing ---
    $sql = "SELECT 
                o.organization_name,
                COALESCE(vqinfo.assigned_to_region, 'N/A') as region,
                COALESCE(vq.country, 'N/A') as country,
                vq.quotestage,
                COALESCE(vq.no_pax, 0) as pax
            FROM " . $unique_quotes_subquery . "
            JOIN vtiger_quotescf qcf ON vq.quoteid = qcf.quoteid
            LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
            LEFT JOIN tdu_contacts c ON c.auto_id = vq.contactid
            LEFT JOIN tdu_organisation o ON o.organizationid = c.organizationid
            WHERE qcf.cf_1162 IS NOT NULL
            AND qcf.cf_1162 BETWEEN ? AND ?
            AND o.organization_name IS NOT NULL AND o.organization_name != ''";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $start_date, $end_date);
    
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $response_data['data'][] = $row;
        }
    }
    
    $stmt->close();
    $conn->close();

} catch (Exception $e) {
    $response_data['success'] = false;
    $response_data['error'] = 'Database query failed: ' . $e->getMessage();
}

echo json_encode($response_data);