<?php
// ajax_fetch_quote_counts.php
// This endpoint fetches the total number of quotes for every organization.

header('Content-Type: application/json');
require_once __DIR__ . '/dbconn.php'; // Ensure this path is correct

if (!$conn) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed.']);
    exit;
}

$response_data = [
    'success' => true,
    'data' => [] // Will be an object: { "Customer Name": count, ... }
];

try {
    // This query counts the number of non-deleted quotes and groups them by the organization name.
    $sql = "SELECT 
                o.organization_name,
                COUNT(vq.quoteid) AS quote_count
            FROM tdu_organisation o
            JOIN tdu_contacts c ON o.organizationid = c.organizationid
            JOIN vtiger_quotes vq ON c.auto_id = vq.contactid
            WHERE vq.deleted = 0
            GROUP BY o.organization_name
            HAVING o.organization_name IS NOT NULL AND o.organization_name != ''";

    $result = $conn->query($sql);
    
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            // Build the key-value pair response
            $response_data['data'][$row['organization_name']] = (int)$row['quote_count'];
        }
    }
    
    $result->close();
    $conn->close();

} catch (Exception $e) {
    $response_data['success'] = false;
    $response_data['error'] = 'Database query failed: ' . $e->getMessage();
}

echo json_encode($response_data);
?>