<?php
// ajax_fetch_quote_details_for_comparison.php
// CORRECTED - Fetches a full DETAIL LIST of quotes filtered by TRAVEL DATE for the QBO comparison panel.

header('Content-Type: application/json');
require_once __DIR__ . '/dbconn.php'; // Ensure this path is correct for your setup

// --- Get Parameters ---
$startDate = $_GET['start_date'] ?? null;
$endDate = $_GET['end_date'] ?? null;

if (!$startDate || !$endDate) {
    echo json_encode(['success' => false, 'error' => 'Missing start_date or end_date parameter.']);
    exit;
}

if (!$conn) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed.']);
    exit;
}

$response_data = ['success' => true, 'data' => []];

try {
    // Subquery to get the first, non-deleted version of a quote by its quote_no
    $unique_quotes_subquery = "(
        SELECT 
            inner_vq.quoteid, inner_vq.quote_no, inner_vq.quotestage, 
            inner_vq.no_pax, inner_vq.country, inner_vq.contactid
        FROM vtiger_quotes inner_vq
        WHERE inner_vq.quoteid = (
            SELECT MIN(sub.quoteid) FROM vtiger_quotes AS sub 
            WHERE sub.quote_no = inner_vq.quote_no AND sub.deleted = 0
        )
    ) vq";

    // Main Query to fetch a detailed list for the frontend panel
    $sql = "SELECT 
                vq.quote_no,
                qcf.cf_1162 AS travel_date,
                o.organization_name,
                COALESCE(vqinfo.assigned_to_sales_agent, 'N/A') as internal_agent,
                COALESCE(vqinfo.assigned_to_external_sales_agent, 'N/A') as external_agent,
                COALESCE(vq.quotestage, 'N/A') as quotestage,
                COALESCE(vq.country, 'N/A') as country,
                COALESCE(vqinfo.assigned_to_region, 'N/A') as region, /* <-- FIX: Region column re-added */
                COALESCE(vq.no_pax, 0) as pax
            FROM " . $unique_quotes_subquery . "
            JOIN vtiger_quotescf qcf ON vq.quoteid = qcf.quoteid
            LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
            LEFT JOIN tdu_contacts c ON c.auto_id = vq.contactid
            LEFT JOIN tdu_organisation o ON o.organizationid = c.organizationid
            WHERE 
                qcf.cf_1162 IS NOT NULL
                AND qcf.cf_1162 BETWEEN ? AND ?
                AND o.organization_name IS NOT NULL AND o.organization_name != ''";

    $stmt = $conn->prepare($sql);
        // --- ADD THIS DEBUGGING BLOCK ---
    if ($stmt === false) {
        // This will tell us exactly what is wrong with the SQL query
        $error_message = "SQL Prepare Failed: " . $conn->error;
        echo json_encode(['success' => false, 'error' => $error_message]);
        exit;
    }
    // --- END DEBUGGING BLOCK ---
    $stmt->bind_param("ss", $startDate, $endDate);
    
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $response_data['data'][] = $row;
        }
    }
    
    $stmt->close();
    $conn->close();

} catch (Exception $e) {
    $response_data['success'] = false;
    $response_data['error'] = 'Database query failed: ' . $e->getMessage();
}

echo json_encode($response_data);
?>