<?php
include "dbconn.php";

$quoteid = $_GET['quoteid'] ?? '';

if (!$quoteid) {
    echo json_encode(['status' => 'error', 'message' => 'Missing quoteid']);
    exit;
}

// Fetch quote details
$sql = "SELECT vq.quoteid, vq.quote_no, vq.mode, vqcf.cf_1162 
        FROM vtiger_quotes vq 
        LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid 
        WHERE vq.quoteid = '$quoteid'";

$result = mysqli_query($conn, $sql);
if (!$result || mysqli_num_rows($result) === 0) {
    echo json_encode(['status' => 'error', 'message' => 'Quote not found']);
    exit;
}

$data = mysqli_fetch_assoc($result);

// Prepare data for POST
$postData = [
    'quoteid' => $quoteid,
    'quote'   => 'Q001',
    'quoteNumber' => $data['quote_no'],
    'mode'     => $data['mode'],
    'dateoftravel'  => $data['cf_1162']
];

// URL to send data to
// $url = 'https://dev.yourbestwayhome.com.au/turtledownunder/export_quote.php';
$url = 'https://dashboard.turtledownunder.com.au/export_quote.php';

// Use cURL to send request
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo json_encode(['status' => 'error', 'message' => curl_error($ch)]);
    curl_close($ch);
    exit;
}

$contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
curl_close($ch);

if (strpos($contentType, 'application/vnd.openxmlformats-officedocument.wordprocessingml.document') === false) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid file type received']);
    exit;
}

// Save to tmp_quotes folder
$timestamp = date('YmdHis');
$quoteNumber = $data['quote_no'];
$fileName = "QUOTE-{$quoteNumber}-{$timestamp}.docx";
$filePath = __DIR__ . "/tmp_quotes/" . $fileName;

if (!file_put_contents($filePath, $response)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to save file']);
    exit;
}

// Return relative file path for browser download
echo json_encode([
    'status' => 'success',
    'fileName' => $fileName,
    'fileUrl' => "tmp_quotes/{$fileName}"
]);
?>
