<?php
// ajax_fetch_report_from_db.php
// CORRECTED VERSION - Fetches the REAL quantity per line.

header('Content-Type: application/json');

require_once __DIR__ . '/dbconn.php';

// --- Get Parameters ---
$startDate = $_GET['start_date'] ?? null;
$endDate = $_GET['end_date'] ?? null;

if (!$startDate || !$endDate) {
    echo json_encode(['success' => false, 'error' => 'Missing start_date or end_date.']);
    exit;
}
if (!$conn) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed.']);
    exit;
}

$reportData = [];

try {
    // MODIFICATION 1: Add il.qty to the SELECT statement
    $sql = "SELECT
                c.qbo_id AS customer_qbo_id,
                c.display_name AS customer_name,
                i.txn_date,
                COALESCE(i.doc_number, CONCAT('ID: ', i.qbo_id)) AS invoice_num,
                il.class_name,
                it.name AS product_service_name,
                il.line_amount,
                il.qty AS line_qty
            FROM
                qbo_invoice_lines AS il
            JOIN
                qbo_invoices AS i ON il.invoice_qbo_id = i.qbo_id
            JOIN
                qbo_customers AS c ON i.customer_qbo_id = c.qbo_id
            JOIN
                qbo_items AS it ON il.item_qbo_id = it.qbo_id
            WHERE
                i.txn_date BETWEEN ? AND ?
            ORDER BY
                c.display_name, i.txn_date";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $startDate, $endDate);
    $stmt->execute();
    $result = $stmt->get_result();
    
    while ($row = $result->fetch_assoc()) {
        $customerId = $row['customer_qbo_id'];

        if (!isset($reportData[$customerId])) {
            $reportData[$customerId] = [
                'customerInfo' => ['id' => $customerId, 'name' => $row['customer_name']],
                'total'    => 0.00,
                'quantity' => 0,
                'details'  => []
            ];
        }

        $reportData[$customerId]['details'][] = [
            'date'          => $row['txn_date'],
            'type'          => 'Invoice',
            'num'           => $row['invoice_num'],
            'class'         => $row['class_name'],
            'product_service' => $row['product_service_name'],
            // MODIFICATION 2: Use the REAL quantity from the database
            'qty'           => (float)($row['line_qty'] ?? 1),
            'amount'        => (float)$row['line_amount'],
            'sales_price'   => (float)$row['line_amount']
        ];
        
        // This part of the original file was summing incorrectly; we let the JS do it.
        // It's better to remove these lines to avoid confusion.
        // $reportData[$customerId]['total'] += (float)$row['line_amount'];
        // $reportData[$customerId]['quantity']++;
    }

    $stmt->close();
    $conn->close();

    echo json_encode([
        'success'      => true,
        'data'         => array_values($reportData) // Use array_values to ensure JS gets a clean array
    ]);

} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => 'Database query failed: ' . $e->getMessage()]);
}