<?php
include 'dbconn.php';

$country = isset($_GET['country']) ? $_GET['country'] : '';
$pax_no_seat = isset($_GET['pax_no_seat']) ? (int) $_GET['pax_no_seat'] : 0;
$productname = isset($_GET['productname']) ? $_GET['productname'] : '';
$vendorname = isset($_GET['vendorname']) ? $_GET['vendorname'] : '';
$city = isset($_GET['city']) ? $_GET['city'] : '';
$seatLimit = isset($_GET['seatLimit']) ? (int) $_GET['seatLimit'] : 0;

$sql_seats = "SELECT DISTINCT CAST(p.seats AS UNSIGNED) AS seat_count 
              FROM tdu_products p
              LEFT JOIN tdu_vendors v ON p.vendorid = v.vendorid
              WHERE p.seats IS NOT NULL 
              AND p.seats != '' 
              AND v.vendorCountry = '$country'
              AND p.productActive = 'Yes' 
              AND v.vendorActive = 'Yes'";

// Apply additional filters
if ($pax_no_seat < 50) {
    $sql_seats .= " AND CAST(p.seats AS UNSIGNED) >= $pax_no_seat ";
}
if ($productname !== '') {
    $sql_seats .= " AND p.productName LIKE '%" . $conn->real_escape_string($productname) . "%'";
}
if ($vendorname !== '') {
    $sql_seats .= " AND v.vendorName LIKE '%" . $conn->real_escape_string($vendorname) . "%'";
}
if ($city !== '') {
    $sql_seats .= " AND p.city LIKE '%" . $conn->real_escape_string($city) . "%'";
}
if ($seatLimit > 0) {
    $sql_seats .= " AND CAST(p.seats AS UNSIGNED) < $seatLimit ";
}

$sql_seats .= " ORDER BY seat_count";

$result_seats = $conn->query($sql_seats);

if ($result_seats->num_rows > 0) {
    while ($row_seats = $result_seats->fetch_assoc()) {
        echo '<button type="button" class="seat-filter-btn" data-seat="' . htmlspecialchars($row_seats['seat_count']) . '">'
            . htmlspecialchars($row_seats['seat_count']) . ' Seats</button>';
    }
} else {
    echo '<p>No seats available for the selected filters.</p>';
}
?>
