<?php
include 'dbconn.php';

$quoteid = isset($_GET['quoteid']) ? $_GET['quoteid'] : '';
$sql = "SELECT quote_no, adults, children, infants FROM vtiger_quotes WHERE quoteid='$quoteid';";
$result = mysqli_query($conn, $sql);
if ($result) {
    $row = mysqli_fetch_assoc($result);
    $quote_number = $row['quote_no'];
    $adults_no = (int) $row['adults'] ?? 0;
    $children_no = (int) $row['children'] ?? 0;
    $pax = $adults_no + $children_no;
    $infants_no = $row['infants'];
}

$daynum = isset($_GET['daynum']) ? $_GET['daynum'] : '';
$productNameFilter = isset($_GET['productname']) ? $_GET['productname'] : '';
$vendorNameFilter = isset($_GET['vendorname']) ? $_GET['vendorname'] : '';
$categoryFilter = isset($_GET['category']) ? $_GET['category'] : '';
$cityFilter = isset($_GET['city']) ? $_GET['city'] : '';

$cityArray = [];
$cityOutboundArray = [];
if ($cityFilter == '') {
    exit();
} else if ($daynum) {
    $sql = "SELECT 
                CASE 
                    WHEN i.productid < 100000000 THEN c.cf_1248 
                    ELSE p.city 
                END AS city,
                CASE 
                    WHEN i.productid < 100000000 THEN '' 
                    ELSE p.keywords 
                END AS keywords
            FROM vtiger_inventoryproductrel i
            LEFT JOIN tdu_products p ON i.productid = p.productid
            LEFT JOIN vtiger_productcf c ON i.productid = c.productid
            WHERE i.id = '$quoteid' AND i.day = '$daynum' AND i.cf_928 != 'Hotel';";
    $result = mysqli_query($conn, $sql);

    if ($result && mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            if(!isset($row['city'])) {
                continue;
            }
            if (!in_array(trim($row['city']), $cityArray)) {
                $cityArray[] = trim($row['city']);
            }
            if (strpos(strtolower($row['keywords']), 'outbound') !== false) {
                $cityOutboundArray[] = trim($row['city']);
            }
        }
    }

    $cityArray = array_values(array_diff($cityArray, $cityOutboundArray));
}
if (count($cityArray) > 0 && !in_array($cityFilter, $cityArray) && !in_array($cityFilter, $cityOutboundArray)) {
    echo '<tr style="background-color: #f8d7da;"><td colspan="6">You cannot add products in other city</td></tr>';
    exit();
}

$countryFilter = isset($_GET['country']) ? $_GET['country'] : '';
$preferred = isset($_GET['preferred']) ? $_GET['preferred'] : 1;
$featured = isset($_GET['featured']) ? $_GET['featured'] : 1;
$keyword = isset($_GET['keyword']) ? $_GET['keyword'] : '';
$seats = isset($_GET['seats']) ? $_GET['seats'] : '';

// if ($categoryFilter == 'Hotel') {
//     $sql = "SELECT 1 FROM vtiger_inventoryproductrel WHERE id='$quoteid' AND day='$daynum' AND cf_928='Hotel';";
//     $result = mysqli_query($conn, $sql);
//     if (mysqli_num_rows($result) > 0) {
//         exit();
//     }
// }

// Base query
$productid = isset($_GET['productid']) ? $_GET['productid'] : '';
$sql = "SELECT p.productid, p.productName, v.vendorName, p.category, p.city, p.keywords, p.preferred, p.featured,
            COALESCE((
                SELECT MIN(na.non_allowed_productid)
                FROM tdu_products_non_allowed na
                WHERE na.productid = p.productid 
                AND na.non_allowed_productid IN (
                    SELECT productid 
                    FROM vtiger_inventoryproductrel 
                    WHERE id = '$quoteid' AND day = '$daynum'
                )
            ), -1) AS isAllowed
        FROM tdu_products p
        LEFT JOIN tdu_vendors v ON p.vendorid = v.vendorid
        WHERE 
            v.vendorActive = 'Yes' 
            AND p.productActive = 'Yes' 
            AND p.productid NOT IN (
                SELECT productid 
                FROM vtiger_inventoryproductrel 
                WHERE id='$quoteid' 
                AND cf_928 = 'Attraction'
            )";

// Apply filters
if ($categoryFilter == 'Transfers' && $pax <= 50) {
    $sql .= " AND CAST(p.seats AS UNSIGNED) >= $pax";
}
if ($productNameFilter != '') {
    $sql .= " AND CONCAT(p.productName, p.keywords) LIKE '%" . $conn->real_escape_string($productNameFilter) . "%'";
}
if ($vendorNameFilter != '') {
    $sql .= " AND v.vendorName LIKE '%" . $conn->real_escape_string($vendorNameFilter) . "%'";
}
if ($categoryFilter != '') {
    $sql .= " AND p.category LIKE '%" . $conn->real_escape_string($categoryFilter) . "%'";
}
if ($cityFilter != '') {
    $sql .= " AND p.city LIKE '%" . $conn->real_escape_string($cityFilter) . "%'";
}
if ($countryFilter != '') {
    $sql .= " AND v.vendorCountry LIKE '%" . $conn->real_escape_string($countryFilter) . "%'";
}
if ($keyword != '') {
    $sql .= " AND p.keywords LIKE '%" . $conn->real_escape_string($keyword) . "%'";
}
if ($categoryFilter == 'Transfers' && $seats != '') {
    $sql .= " AND p.seats = '$seats'";
}
if ($preferred == 1) {
    $sql .= " AND p.preferred=$preferred ";
}
if ($featured == 1) {
    $sql .= " AND p.featured=$featured ";
}

$sql .= " ORDER BY p.preferred DESC, p.featured DESC";
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * 20;
$sql .= " LIMIT 20 OFFSET $offset";
$result = $conn->query($sql);
?>

<?php if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) { ?>
        <tr>
            <td style="text-align: left;">
                <?= $row['preferred'] > 0 ? '<i class="fa-solid fa-star" style="color:rgb(255, 145, 0);" title="Preferred"></i>' : '' ?> 
                <?= $row['featured'] > 0 ? '<i class="fa-solid fa-fire" style="color: red;" title="Popular"></i>' : '' ?> 
                <?php echo htmlspecialchars($row['productName']); ?>
            </td>
            <td style="text-align: left;"><?php echo htmlspecialchars($row['vendorName']); ?></td>
            <td style="text-align: left;">
                <?php if ($row['category'] != 'Hotel') { ?>
                    <input type="hidden" name="day" class="day-input" value="<?= $daynum ?>" style="width: 30px; border: none; background-color: unset;" readonly id="day-<?php echo $row['productid']; ?>">
                <?php } else { ?>
                    <input type="hidden" name="nights" class="nights-input" value="1" style="width: 45px;" id="nights-<?php echo $row['productid']; ?>" min="1">
                <?php } ?>
                <?php
                $isAllowed = (int) $row['isAllowed'];
                if($isAllowed > 0) {
                    $sqlr = "SELECT productName FROM tdu_products WHERE productid = '$isAllowed' LIMIT 1;";
                    $resultr = $conn->query($sqlr);
                    $rowr = $resultr->fetch_assoc();
                    $productnamer = $rowr['productName'];
                }
                ?>
                <button class="associate-btn" data-productid="<?php echo $row['productid']; ?>" 
                    <?= $isAllowed >= 0 ? 'disabled' : '' ?>
                    <?= $isAllowed >= 0 ? 'title="Non-allowed Product: ' . $productnamer . '"' : '' ?>
                >
                    <i class="fa-solid fa-plus"></i>
                </button>
            </td>
        </tr>
    <?php }
} else { ?>
    <tr>
        <td colspan="6">No More records</td>
    </tr>
<?php } ?>
