<?php
// Set the content type to application/json for AJAX response
header('Content-Type: application/json');

require_once "dbconn.php"; // Ensure this path is correct
require_once "quote_pricing.php"; // Ensure this path is correct

// Initialize response array
$responseData = [
    'quote_no' => null,
    'accountName' => null,
    'address' => null,
    'subject' => null,
    'country' => null,
    'payment_deadline' => null,
    'content' => [],
    'error' => null
];

// Get quoteid from request (GET or POST)
$quoteid = isset($_REQUEST['quoteid']) ? mysqli_real_escape_string($conn, $_REQUEST['quoteid']) : null;

if (empty($quoteid)) {
    $responseData['error'] = "Quote ID is required.";
    echo json_encode($responseData);
    exit();
}

// --- Start of your existing logic, adapted for AJAX ---

// Initialize variables that will be populated
$accountName = '';
$address = '';
$subject = '';
$country = '';
$currency = 'AUD'; // Default currency
$adults_no = 0;
$children_no = 0;
$infants_no = 0;
$payment_deadline = '';
$quote_no = '';
$content = [];

// Fixed mode, or make it a parameter if needed
$mode = 'group';

$invoice_initial_query = "SELECT MAX(created_at) AS created_at FROM vtiger_invoice WHERE quoteid = '$quoteid' AND type = 'final'";
$invoice_initial_result = mysqli_query($conn, $invoice_initial_query);

if (!$invoice_initial_result) {
    $responseData['error'] = "Database error (invoice_initial_query): " . mysqli_error($conn);
    echo json_encode($responseData);
    exit();
}
$invoice_initial = mysqli_fetch_assoc($invoice_initial_result);
$created_at_query = !empty($invoice_initial['created_at']) ? $invoice_initial['created_at'] : null;

if($created_at_query) {
    $created_at_query = " AND created_at < '" . mysqli_real_escape_string($conn, $created_at_query) . "' ";
} else { 
    $created_at_query = "";
}

// query the room info
$sql_rooms = "SELECT meta_key, meta_value 
        FROM vtiger_itinerary 
        WHERE quoteid = '$quoteid' 
        AND meta_key IN ('single_rooms', 'double_rooms', 'triple_rooms', 'child_without_bed')
        AND (meta_key, created_at) IN (
            SELECT meta_key, MAX(created_at)
            FROM vtiger_itinerary
            WHERE quoteid = '$quoteid' $created_at_query
            AND meta_key IN ('single_rooms', 'double_rooms', 'triple_rooms', 'child_without_bed')
            GROUP BY meta_key);";
$result_rooms = mysqli_query($conn, $sql_rooms);

if (!$result_rooms) {
    $responseData['error'] = "Database error (sql_rooms): " . mysqli_error($conn);
    echo json_encode($responseData);
    exit();
}

$single_rooms = 0;
$double_rooms = 0;
$triple_rooms = 0;
$child_no_bed = 0;
while ($row_room = mysqli_fetch_assoc($result_rooms)) {
    switch ($row_room['meta_key']) {
        case 'single_rooms':
            $single_rooms = (int) $row_room['meta_value'];
            break;
        case 'double_rooms':
            $double_rooms = (int) $row_room['meta_value'];
            break;
        case 'triple_rooms':
            $triple_rooms = (int) $row_room['meta_value'];
            break;
        case 'child_without_bed':
            $child_no_bed = (int) $row_room['meta_value'];
            break;
    }
}

// query the quote information
$sql_quote_info = "SELECT vq.quoteid, vq.subject, vq.adults, vq.children, vq.infants, va.organization_name AS accountname, va.address, vqcf.cf_1182, vq.country
        FROM vtiger_quotes vq
        LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
        LEFT JOIN tdu_organisation va ON vq.accountid = va.organizationid
        WHERE vq.quoteid = '$quoteid'
        LIMIT 1;";
$result_quote_info = mysqli_query($conn, $sql_quote_info);

if (!$result_quote_info) {
    $responseData['error'] = "Database error (sql_quote_info): " . mysqli_error($conn);
    echo json_encode($responseData);
    exit();
}

if (mysqli_num_rows($result_quote_info) > 0) {
    $row_quote = mysqli_fetch_assoc($result_quote_info);
    if ($row_quote) {
        $accountName = isset($row_quote['accountname']) ? str_replace('&', 'and', $row_quote['accountname']) : '';
        $address = isset($row_quote['address']) ? str_replace('&', 'and', $row_quote['address']) : '';
        $subject = isset($row_quote['subject']) ? str_replace('&', 'and', $row_quote['subject']) : '';
        $country = $row_quote['country'] ?? '';
        
        if($country == 'New Zealand') {
            $currency = 'NZD';
        } else {
            $currency = 'AUD'; // Default or based on other logic if needed
        }

        $adults_no = (int) ($row_quote['adults'] ?? 0);
        $children_no = (int) ($row_quote['children'] ?? 0);
        $infants_no = (int) ($row_quote['infants'] ?? 0);
        $no_pax = $adults_no + $children_no;
        
        if($no_pax == 0) {
            $responseData['error'] = "No of passengers not entered for this quote.";
            echo json_encode($responseData);
            exit();
        }
        if (isset($row_quote['cf_1182']) && $row_quote['cf_1182'] != '0000-00-00' && !empty($row_quote['cf_1182'])) {
            try {
                $date = new DateTime($row_quote['cf_1182']);
                $payment_deadline = $date->format('d-M-Y');
            } catch (Exception $e) {
                $payment_deadline = ''; // Or log error, or use original value if parsing fails
            }
        }
    }
} else {
    $responseData['error'] = "Quote details not found for ID: " . $quoteid;
    echo json_encode($responseData);
    exit();
}

$child_with_bed = $children_no - $child_no_bed;
if ($child_with_bed < 0) $child_with_bed = 0; // Ensure it's not negative


$quote_pax = -1; // Default value
if($mode == 'group') {
    $mode_sql = '>1'; // Be cautious with directly inserting variables into SQL if $mode can be user-supplied.
                    // Here it's fixed, which is safer.
    $sql_group_sum = "SELECT MIN(vps.pax_min) AS pax_min, MAX(vps.pax_max) AS pax_max
                    FROM vtiger_products_saleprice vps
                    WHERE vps.quoteid='$quoteid' AND vps.subquoteid $mode_sql AND vps.cf_928='Transfers'
                    GROUP BY vps.subquoteid
                    ORDER BY pax_min ASC;";
    $result_group_sum = mysqli_query($conn, $sql_group_sum);
    if ($result_group_sum && mysqli_num_rows($result_group_sum) > 0) {
        while ($row_group_sum = mysqli_fetch_assoc($result_group_sum)) {
            if ($row_group_sum['pax_min'] <= ($adults_no+$children_no) && ($adults_no+$children_no) <= $row_group_sum['pax_max']) {
                $quote_pax = $row_group_sum['pax_min'];
                break;
            }
        }
    }
}

// Assuming getQuotePricing function is loaded and works correctly
$pricing = getQuotePricing($conn, $quoteid, $quote_pax);
if (!is_array($pricing) || empty($pricing)) {
     $responseData['error'] = "Could not retrieve pricing information.";
    // Fallback for pricing to avoid errors, or handle more gracefully
    $pricing = [
        'single_room' => 0, 'double_room' => 0, 'triple_room' => 0,
        'child_with_bed' => 0, 'child_no_bed' => 0, 'infant' => 0
    ];
    // Optionally, you might want to exit here or log this issue
    // echo json_encode($responseData);
    // exit();
}

$pricing_single_room = $pricing['single_room'] ?? 0;
$pricing_double_room = $pricing['double_room'] ?? 0;
$pricing_triple_room = $pricing['triple_room'] ?? 0;
$pricing_child_with_bed = $pricing['child_with_bed'] ?? 0;
$pricing_child_no_bed = $pricing['child_no_bed'] ?? 0;
$pricing_infant = $pricing['infant'] ?? 0;

// --- Build $content array (line items) ---
if ($single_rooms > 0) {
    $content[] = ['Product'=>'Package Cost Per Adult on Single Occupancy', 'Currency'=>$currency, 'Pricing'=>(float)$pricing_single_room, 'Number'=>(int)$single_rooms];
}

if ($double_rooms > 0) {
    $content[] = ['Product'=>'Package Cost Per Adult on Double Occupancy', 'Currency'=>$currency, 'Pricing'=>(float)$pricing_double_room, 'Number'=>(int)($double_rooms * 2)];
}

if ($triple_rooms > 0) {
    $adults_in_triple = $triple_rooms * 3 - $child_with_bed;
    if ($adults_in_triple < 0) $adults_in_triple = 0; // Prevent negative numbers

    if ($adults_in_triple > 0) {
        $content[] = ['Product'=>'Package Cost Per Adult on Triple Occupancy', 'Currency'=>$currency, 'Pricing'=>(float)$pricing_triple_room, 'Number'=>(int)$adults_in_triple];
    }
}

if ($single_rooms == 0 && $double_rooms == 0 && $triple_rooms == 0) { // No rooms selected means "No Hotel" option
    if($adults_no > 0) {
        $content[] = ['Product'=>'Package Cost Per Adult No Hotel', 'Currency'=>$currency, 'Pricing'=>(float)$pricing_single_room, 'Number'=>(int)$adults_no];
    }
    // For "No Hotel" child, the pricing might be different.
    // The original code used $pricing_child_no_bed for "Package Cost Per Child No Hotel"
    // and $pricing_single_room for "Package Cost Per Adult No Hotel"
    // This seems potentially inconsistent for pricing_single_room for adults "No Hotel",
    // ensure getQuotePricing provides a specific rate for "Adult No Hotel" if needed.
    // For now, sticking to original logic:
    if($children_no > 0) { // If any children exist, and no rooms are chosen
        // This block assumes all children are without bed if no rooms are specified.
        // Or you might need specific pricing for "Child No Hotel"
        $content[] = ['Product'=>'Package Cost Per Child No Hotel', 'Currency'=>$currency, 'Pricing'=>(float)$pricing_child_no_bed, 'Number'=>(int)$children_no];
    }
} else { // This else block implies rooms were selected
    if ($child_with_bed > 0) {
        $content[] = ['Product'=>'Package Cost Per Child with Bed', 'Currency'=>$currency, 'Pricing'=>(float)$pricing_child_with_bed, 'Number'=>(int)$child_with_bed];
    }
    if ($child_no_bed > 0) {
        $content[] = ['Product'=>'Package Cost Per Child without Bed', 'Currency'=>$currency, 'Pricing'=>(float)$pricing_child_no_bed, 'Number'=>(int)$child_no_bed];
    }
}

if($infants_no > 0) {
    $content[] = ['Product'=>'Package Cost Per Infant', 'Currency'=>$currency, 'Pricing'=>(float)$pricing_infant, 'Number'=>(int)$infants_no];
}
    
$sql_adjustments = "SELECT remark, product_field, price_field, quantity FROM vtiger_invoice_add_products WHERE quoteid='$quoteid' ORDER BY created_at DESC";
$result_adjustments = mysqli_query($conn, $sql_adjustments);

if ($result_adjustments) {
    while ($row_adjustment = $result_adjustments->fetch_assoc()) {
        $remark_cleaned = isset($row_adjustment['remark']) ? str_replace('&', 'and', $row_adjustment['remark']) : '';
        $product_field_cleaned = isset($row_adjustment['product_field']) ? str_replace('&', 'and', $row_adjustment['product_field']) : '';
        $price_field = (float) ($row_adjustment['price_field'] ?? 0);
        $quantity = (int) ($row_adjustment['quantity'] ?? 0);
        
        $content[] = [
            'Product' => $remark_cleaned, 
            'Description'=> $product_field_cleaned, 
            'Currency' => $currency, 
            'Pricing' => $price_field, 
            'Number' => $quantity
        ];
    }
} else {
    // Log error or handle if adjustment query fails
    // $responseData['warning_adjustments'] = "Could not fetch adjustments: " . mysqli_error($conn);
}

// Refunds are processed but not added to $content to match the example output provided by the user.
// If refunds need to be in the JSON, their structure in $content needs to be defined.
$sql_refunds = "SELECT product, refund_reason, refund_amount FROM vtiger_invoice_refunds WHERE quoteid='$quoteid' ORDER BY created_at DESC";
$result_refunds = mysqli_query($conn, $sql_refunds);
if ($result_refunds && $result_refunds->num_rows > 0) {
    while ($row_refund = $result_refunds->fetch_assoc()) {
        // $product = str_replace('&', 'and', $row_refund['product']);
        // $refund_amount = (float) $row_refund['refund_amount'];
        // $refund_reason = $row_refund['refund_reason'];
        // Example of how it might be added if needed:
        // $content[] = ['Product'=>"Reduction: " . $product, 'Description'=>$refund_reason, 'Currency'=>$currency, 'Pricing'=>-$refund_amount, 'Number'=>1];
    }
}

// Get quote_no
$quote_number_sql = "SELECT quote_no FROM `vtiger_quotes` where quoteid = '$quoteid' LIMIT 1";
$quote_number_result = mysqli_query($conn, $quote_number_sql);
if ($quote_number_result && $quote_number_row = mysqli_fetch_assoc($quote_number_result)) {
    $quote_no = $quote_number_row['quote_no'];
}


// Populate response data
$responseData['quote_no'] = $quote_no;
$responseData['accountName'] = $accountName;
$responseData['address'] = $address;
$responseData['subject'] = $subject;
$responseData['country'] = $country;
$responseData['payment_deadline'] = $payment_deadline;
$responseData['content'] = $content;

// Output the JSON response
echo json_encode($responseData, JSON_PRETTY_PRINT); // JSON_PRETTY_PRINT for readability during testing

?>