<?php
include 'dbconn.php';

header('Content-Type: application/json');

$quoteid = $_POST['quoteid'] ?? '';
$sequence_no = $_POST['sequence_no'] ?? '';

if (empty($quoteid) || empty($sequence_no)) {
    echo json_encode(['success' => false, 'message' => 'Missing quoteid or sequence_no']);
    exit;
}

// Function to get the latest value for a meta_key
function getLatestMetaValue($conn, $quoteid, $sequence_no, $meta_key) {
    $sql = "SELECT meta_value 
            FROM vtiger_itinerary 
            WHERE quoteid = ? AND sequence_no = ? AND meta_key = ?
            ORDER BY created_at DESC 
            LIMIT 1";

    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "iis", $quoteid, $sequence_no, $meta_key);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $row = mysqli_fetch_assoc($result);
    return $row['meta_value'] ?? '';
}

$pickup_location = getLatestMetaValue($conn, $quoteid, $sequence_no, 'pickup_location');
$dropoff_location = getLatestMetaValue($conn, $quoteid, $sequence_no, 'dropoff_location');

echo json_encode([
    'success' => true,
    'pickup_location' => $pickup_location,
    'dropoff_location' => $dropoff_location
]);
?>
