<?php
include "rezdyconn.php";

if (!isset($_POST['supplierName'])) {
    echo "Invalid supplier name.";
    exit;
}

$supplierName = mysqli_real_escape_string($rezdyconn, $_POST['supplierName']);

$sql = "SELECT productCode, name, supplierName, city, countryCode, currency, advertisedPrice, rate 
        FROM products 
        WHERE supplierName = '$supplierName'
        ORDER BY name ASC";

$result = mysqli_query($rezdyconn, $sql);

if (!$result || mysqli_num_rows($result) === 0) {
    echo "No products found.";
    exit;
}

echo "<table class='supplier-preview-table' border='1' cellpadding='5' cellspacing='0'>";
echo "<tr>
        <th>Product Code</th>
        <th>Name</th>
        <th>City</th>
        <th>Country</th>
        <th>Price</th>
        <th>Rate</th>
      </tr>";

while ($row = mysqli_fetch_assoc($result)) {
    echo "<tr>
            <td>" . htmlspecialchars($row['productCode']) . "</td>
            <td>" . htmlspecialchars($row['name']) . "</td>
            <td>" . htmlspecialchars($row['city']) . "</td>
            <td>" . htmlspecialchars($row['countryCode']) . "</td>
            <td>" . htmlspecialchars($row['currency']) . ' ' . htmlspecialchars($row['advertisedPrice']) . "</td>
            <td>" . htmlspecialchars($row['rate']) . "</td>
          </tr>";
}

echo "</table>";
?>
<style>
    .supplier-preview-table {
        width: 100%;
        border-collapse: collapse;
    }
    .supplier-preview-table th, .supplier-preview-table td {
        padding: 10px;
        text-align: left;
    }
</style>
