<?php
// Include database connection
include 'dbconn.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $productid = $_POST['productid'];

    // Prepare and execute the query
    $stmt = $conn->prepare("
        SELECT p.productid, p.productName, v.vendorName
        FROM tdu_products_suggested s
        LEFT JOIN tdu_products p ON s.suggested = p.productid
        LEFT JOIN tdu_vendors v ON p.vendorid = v.vendorid
        WHERE s.productid = ?
    ");
    $stmt->bind_param("i", $productid);
    $stmt->execute();
    $result = $stmt->get_result();

    $products = [];
    while ($row = $result->fetch_assoc()) {
        $products[] = $row; // Add each product's info (productid, productName, vendorName) to the products array
    }

    echo json_encode([
        'status' => 'success',
        'products' => $products
    ]);
    exit;
}

echo json_encode([
    'status' => 'error',
    'message' => 'Invalid request'
]);
exit;
?>
