<?php
// hotel rooming list

include "dbconn.php";

session_start();

// Redirect to login page if not logged in
if (!isset($_SESSION['user_name'])) {
    header('Location: login.php');
    exit;
}

if (isset($_POST['upload'])) {
    $quote_id = $_POST['quoteid'];
    $quote_number = $_POST['quoteNumber'];
    // Check if a file was uploaded
    if (isset($_FILES['csv_file']) && $_FILES['csv_file']['error'] === 0) {
        // Open the uploaded CSV file
        $csvFile = fopen($_FILES['csv_file']['tmp_name'], 'r');
        
        // Skip the first line (header row)
        fgetcsv($csvFile);

        $sql = "DELETE FROM vtiger_pax_in_hotel WHERE quoteid='$quote_id';";
        mysqli_query($conn, $sql) or die(mysqli_error($conn));

        // Read each row of the CSV file
        while (($row = fgetcsv($csvFile)) !== false) {
            // Escape the data to prevent SQL injection
            $room_type = $conn->real_escape_string($row[0]);
            $num_child = isset($row[1]) && $row[1] !== '' ? (int)$row[1] : 0; // Set to 0 if not set or empty
            $child_type = $conn->real_escape_string($row[2]);
            $room_seq_no = $conn->real_escape_string($row[3]);
            $title = $conn->real_escape_string($row[4]);
            $surname = $conn->real_escape_string($row[5]);
            $given_name = $conn->real_escape_string($row[6]);

            // Create the SQL query
            $sql = "INSERT INTO vtiger_pax_in_hotel (quoteid, room_type, num_child, child_type, room_seq_no, title, surname, given_name) 
                    VALUES ('$quote_id', '$room_type', $num_child, '$child_type', '$room_seq_no', '$title', '$surname', '$given_name')";

            // Execute the SQL query
            if (!$conn->query($sql)) {
                echo "Error: " . $conn->error;
            }
        }

        // Close the CSV file and database connection
        fclose($csvFile);
        $conn->close();

        header('Location: quote.php?opt=hotel-pax&quoteid='.$quote_id.'&quoteNumber='.$quote_number); 
        exit();
    } else {
        echo "Error uploading the file.";
    }
}

else if (isset($_POST['download'])) {
    $quote_id = $_POST['quoteid'];
    $sql = "SELECT * FROM vtiger_pax_in_hotel WHERE quoteid = '$quote_id';";
    $result = $conn->query($sql);

    $quote_number = $_POST['quoteNumber'];
    $current_time = date('Y-m-d-H-i-s');
    $filename = "{$quote_number}-hotel-{$current_time}.csv";

    header('Content-Type: text/csv');
    header("Content-Disposition: attachment; filename=\"{$filename}\"");
    header('Pragma: no-cache');
    header('Expires: 0');
    $output = fopen('php://output', 'w');
    fputcsv($output, ['room_type', 'num_child', 'child_type', 'room_seq_no', 'title', 'surname', 'given_name']);

    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            fputcsv($output, [
                $row['room_type'],
                $row['num_child'],
                $row['child_type'],
                $row['room_seq_no'],
                $row['title'],
                $row['surname'],
                $row['given_name']
            ]);
        }
    }
    fclose($output);
    exit();
}
?>
