<?php
include "dbconn.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $validCategories = ['Attraction', 'Hotel', 'Restaurant', 'Tour', 'Transfers', 'Guide', 'SIC'];
    $failed_row = false;

    if (isset($_FILES['csv_file']) && $_FILES['csv_file']['error'] === UPLOAD_ERR_OK) {
        $fileTmpPath = $_FILES['csv_file']['tmp_name'];
        $vendor_id = $_POST['vendor_id']; // Capture vendor ID from the form

        // Validate vendor ID
        if (!is_numeric($vendor_id)) {
            die('Invalid vendor ID.');
        }

        // Validate file type
        $fileExtension = pathinfo($_FILES['csv_file']['name'], PATHINFO_EXTENSION);
        if ($fileExtension !== 'csv') {
            die('Invalid file type. Please upload a CSV file.');
        }

        // Open CSV file
        if (($handle = fopen($fileTmpPath, 'r')) !== false) {

            // Skip the header row
            fgetcsv($handle);

            // Process rows
            $rowCount = 0;
            while (($row = fgetcsv($handle)) !== false) {
                $productid = $conn->real_escape_string($row[0]);
                if (!isset($productid) || $productid == '') {
                    continue;
                }
                $productName = $conn->real_escape_string($row[1]);
                $country = trim($conn->real_escape_string($row[2]));
                $productActive = $conn->real_escape_string($row[3]);
                $category = $conn->real_escape_string($row[4]);
                if (!in_array($category, $validCategories)) {
                    echo "Row " . $productid . ": " . $productName . " category is not available\n";
                    $failed_row = true;
                    continue;
                }
                $city = trim($conn->real_escape_string($row[5]));
                $description = $conn->real_escape_string($row[6]);
                $unitPrice = $conn->real_escape_string($row[7]);
                $childPrice = $conn->real_escape_string($row[8]);
                $infantPrice = $conn->real_escape_string($row[9]);
                $sharingPrice = $conn->real_escape_string($row[10]);
                $triplePrice = $conn->real_escape_string($row[11]);
                $childWithBedPrice = $conn->real_escape_string($row[12]);
                $childNoBedPrice = $conn->real_escape_string($row[13]);

                // Check if product already exists for this vendor
                $checkQuery = "SELECT COUNT(*) AS count FROM tdu_products WHERE vendorid = '$vendor_id' AND productName = '$productName'";
                $result = $conn->query($checkQuery);
                $rowExists = $result->fetch_assoc();

                if ($rowExists['count'] > 0) {
                    // Update existing record
                    $sql = "UPDATE tdu_products SET 
                        country = '$country',
                        productActive = '$productActive',
                        category = '$category',
                        city = '$city',
                        description = '$description',
                        unitPrice = '$unitPrice',
                        childPrice = '$childPrice',
                        infantPrice = '$infantPrice',
                        sharingPrice = '$sharingPrice',
                        triplePrice = '$triplePrice',
                        childWithBedPrice = '$childWithBedPrice',
                        childNoBedPrice = '$childNoBedPrice'
                    WHERE vendorid = '$vendor_id' AND productName = '$productName'";
                } else {
                    // Insert new record
                    $sql = "INSERT INTO tdu_products (vendorid, productName, country, productActive, category, city, description, unitPrice, childPrice, infantPrice, sharingPrice, triplePrice, childWithBedPrice, childNoBedPrice)
                        VALUES ('$vendor_id', '$productName', '$country', '$productActive', '$category', '$city', '$description', '$unitPrice', '$childPrice', '$infantPrice', '$sharingPrice', '$triplePrice', '$childWithBedPrice', '$childNoBedPrice')";
                }

                if ($conn->query($sql)) {
                    $rowCount++;
                }
            }

            fclose($handle);
            $conn->close();

            if($failed_row) {
                echo "\nAvailable categories: Attraction, Hotel, Restaurant, Tour, Transfers, Guide, SIC \n\n";
            }

            echo "$rowCount rows successfully processed.";
        } else {
            die('Error opening the file.');
        }
    } else {
        die('No file uploaded or an error occurred.');
    }
} else {
    die('Invalid request method.');
}
?>
