<?php
include 'dbconn.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $quoteid = isset($_POST['quoteid']) ? (int) trim($_POST['quoteid']) : '';
    $itineraryid = isset($_POST['itineraryid']) ? (int) trim($_POST['itineraryid']) : '';
    $fromday = isset($_POST['fromday']) ? (int) trim($_POST['fromday']) : '';
    $today = isset($_POST['today']) ? (int) trim($_POST['today']) : '';

    if (empty($quoteid) || empty($itineraryid)) {
        echo json_encode(['status' => 'error', 'message' => 'Missing required parameters.']);
        exit;
    }

    // Copy all rows where quoteid = $itineraryid to quoteid = $quoteid
    $stmt = $conn->prepare("INSERT INTO vtiger_itinerary_new_event (quoteid, sequence_no, tour_time, event_name, sub_sequence_no, day)
                            SELECT ?, sequence_no, tour_time, event_name, sub_sequence_no, ? FROM vtiger_itinerary_new_event WHERE quoteid = ? AND day = ?");
    $stmt->bind_param("iiii", $quoteid, $today, $itineraryid, $fromday);
    
    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Events copied successfully.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to copy events.']);
    }
    
    $stmt->close();
    $conn->close();
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}
