<?php
session_start();

include 'dbconn.php';

$username = $_SESSION['user_name'];
$sql_ajax = "SELECT CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users WHERE user_name = '$username';";
$result_ajax = mysqli_query($conn, $sql_ajax);
if(mysqli_num_rows($result_ajax) > 0) {
    $row_ajax = $result_ajax->fetch_assoc();
    $username_ajax = $row_ajax['name'];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $adjustment_type = mysqli_real_escape_string($conn, $_POST['adjustment_type']);

    if ($adjustment_type === 'add_product') {
        $quoteid = mysqli_real_escape_string($conn, $_POST['quoteid']);
        $category = mysqli_real_escape_string($conn, $_POST['category']);
        $day = mysqli_real_escape_string($conn, $_POST['day']);
        $date = mysqli_real_escape_string($conn, $_POST['date']);
        $vendor = mysqli_real_escape_string($conn, $_POST['vendor']);
        $product = mysqli_real_escape_string($conn, $_POST['product']);
        $price = mysqli_real_escape_string($conn, $_POST['price']);
        $quantity = mysqli_real_escape_string($conn, $_POST['quantity']);
        $remark = mysqli_real_escape_string($conn, $_POST['remark']);

        $sql = "INSERT INTO vtiger_invoice_add_products (quoteid, cf_928, day_field, vendor_field, product_field, price_field, quantity, remark) 
                VALUES ('$quoteid', '$category', '$day', '$vendor', '$product', '$price', '$quantity', '$remark')";

        if (mysqli_query($conn, $sql)) {
            $unique_void_id = mysqli_insert_id($conn);
            $_POST['unique_void_id'] = $unique_void_id;

            $details = "Add product\nProduct: $product\nVendor: $vendor\nPrice: $$price\nQuantity: $quantity\nRemark: $remark";

            // Insert into the history table with details
            $sql2 = "INSERT INTO vtiger_invoice_adjustment_history (quoteid, details, created_by) 
                    VALUES ('$quoteid', '" . mysqli_real_escape_string($conn, $details) . "', '$username_ajax')";
            mysqli_query($conn, $sql2);

            $insert_id = mysqli_insert_id($conn);
            $revert_data = json_encode($_POST, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
            $insert_revert = "INSERT INTO vtiger_invoice_adjustment_revert (auto_id, quoteid, adjustment_type, revert_data, created_by) 
                              VALUES ('$insert_id', '$quoteid', '$adjustment_type', '" . mysqli_real_escape_string($conn, $revert_data) . "', '$username_ajax')";
            mysqli_query($conn, $insert_revert);

            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false, 'error' => mysqli_error($conn)]);
        }
    } else if ($adjustment_type === 'adjust_product_price') {
        $quoteid = mysqli_real_escape_string($conn, $_POST['quoteid']);
        $category = mysqli_real_escape_string($conn, $_POST['category']);
        $sequence_no = mysqli_real_escape_string($conn, $_POST['product']);
        $adjustment_sign = mysqli_real_escape_string($conn, $_POST['adjustment_sign']);
        $adjustment_amount = (float) mysqli_real_escape_string($conn, $_POST['adjustment_amount']);

        $adjustment_amount = ($adjustment_sign === '+') ? $adjustment_amount : (-1)*$adjustment_amount;

        $sql_fetch = "SELECT vi.day, vp.productName 
                    FROM vtiger_inventoryproductrel vi
                    LEFT JOIN tdu_products vp ON vi.productid = vp.productid
                    WHERE vi.id = '$quoteid' AND vi.sequence_no = '$sequence_no'";
        $result_fetch = mysqli_query($conn, $sql_fetch);

        if ($result_fetch && mysqli_num_rows($result_fetch) > 0) {
            $row_fetch = mysqli_fetch_assoc($result_fetch);
            $day = mysqli_real_escape_string($conn, $row_fetch['day']);
            $productName = mysqli_real_escape_string($conn, $row_fetch['productName']);
        } else {
            $day = '';
            $productName = '';
        }

        // Update the product prices
        $sql = "UPDATE vtiger_products_saleprice 
                SET sale_price = sale_price + $adjustment_amount, 
                    sale_price_child = sale_price_child + $adjustment_amount, 
                    price_adjust = price_adjust + $adjustment_amount
                WHERE quoteid = '$quoteid' AND sequence_no = '$sequence_no'";

        if (mysqli_query($conn, $sql)) {
            // Prepare details for adjustment history
            $details = "Adjust Price\nDay: $day\nProduct: $productName\nAdjustment Amount: " . ($adjustment_amount > 0 ? "+$adjustment_amount" : $adjustment_amount);

            // Insert into adjustment history
            $sql2 = "INSERT INTO vtiger_invoice_adjustment_history (quoteid, details, created_by) 
                    VALUES ('$quoteid', '" . mysqli_real_escape_string($conn, $details) . "', '$username_ajax')";
            mysqli_query($conn, $sql2);

            $insert_id = mysqli_insert_id($conn);
            $revert_data = json_encode($_POST, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
            $insert_revert = "INSERT INTO vtiger_invoice_adjustment_revert (auto_id, quoteid, adjustment_type, revert_data, created_by) 
                              VALUES ('$insert_id', '$quoteid', '$adjustment_type', '" . mysqli_real_escape_string($conn, $revert_data) . "', '$username_ajax')";
            mysqli_query($conn, $insert_revert);

            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false, 'error' => mysqli_error($conn)]);
        }
    } else if ($adjustment_type === 'adjust_overall_pax') {
        $quoteid = mysqli_real_escape_string($conn, $_POST['quoteid']);
        $adults = (int) mysqli_real_escape_string($conn, $_POST['adults_amount']) * ($_POST['adults_sign'] === '+' ? 1 : -1);
        $children = (int) mysqli_real_escape_string($conn, $_POST['children_amount']) * ($_POST['children_sign'] === '+' ? 1 : -1);
        $infants = (int) mysqli_real_escape_string($conn, $_POST['infants_amount']) * ($_POST['infants_sign'] === '+' ? 1 : -1);
        $single_room = (int) mysqli_real_escape_string($conn, $_POST['single_room_amount']) * ($_POST['single_room_sign'] === '+' ? 1 : -1);
        $double_room = (int) mysqli_real_escape_string($conn, $_POST['double_room_amount']) * ($_POST['double_room_sign'] === '+' ? 1 : -1);
        $triple_room = (int) mysqli_real_escape_string($conn, $_POST['triple_room_amount']) * ($_POST['triple_room_sign'] === '+' ? 1 : -1);
    
        $sql = "UPDATE vtiger_quotes 
                SET adults = adults + $adults, 
                    children = children + $children, 
                    infants = infants + $infants, 
                    nsingle_room = nsingle_room + $single_room, 
                    ndouble_room = ndouble_room + $double_room, 
                    ntriple_room = ntriple_room + $triple_room 
                WHERE quoteid = '$quoteid'";
    
        if (mysqli_query($conn, $sql)) {
            $sequence_sql = "SELECT sequence_no, cf_928 FROM vtiger_inventoryproductrel WHERE id = '$quoteid'";
            $sequence_result = mysqli_query($conn, $sequence_sql);

            // Loop through each sequence_no and process the meta values
            while ($row = mysqli_fetch_assoc($sequence_result)) {
                $sequence_no = $row['sequence_no'];
                $cf_928 = $row['cf_928'];

                if($cf_928 != 'Transfers') {
                    $meta_keys = ['adults', 'children', 'infants'];
                    foreach ($meta_keys as $meta_key) {
                        $meta_sql = "SELECT meta_value 
                                    FROM vtiger_itinerary 
                                    WHERE quoteid = '$quoteid' AND sequence_no = '$sequence_no' AND meta_key = '$meta_key' 
                                    ORDER BY created_at DESC LIMIT 1";
                        $meta_result = mysqli_query($conn, $meta_sql);
                        $latest_meta = mysqli_fetch_assoc($meta_result);
                        $latest_pax[$meta_key] = (int) ($latest_meta['meta_value'] ?? 0);
                    }
    
                    $new_adults = $latest_pax['adults'] + $adults;
                    $new_children = $latest_pax['children'] + $children;
                    $new_infants = $latest_pax['infants'] + $infants;

                    // Insert new meta values if there was a change
                    if ($adults != 0) {
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                    VALUES ('$quoteid', '$sequence_no', 'adults', '$new_adults', NOW(), '$username_ajax')";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                    }
                    if ($children != 0) {
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                    VALUES ('$quoteid', '$sequence_no', 'children', '$new_children', NOW(), '$username_ajax')";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                    }
                    if ($infants != 0) {
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                    VALUES ('$quoteid', '$sequence_no', 'infants', '$new_infants', NOW(), '$username_ajax')";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                    }
                }

                if($cf_928 == 'Hotel') {
                    $meta_keys = ['single_rooms', 'double_rooms', 'triple_rooms'];
                    $latest_pax = [];
                    foreach ($meta_keys as $meta_key) {
                        $meta_sql = "SELECT meta_value 
                                    FROM vtiger_itinerary 
                                    WHERE quoteid = '$quoteid' AND sequence_no = '$sequence_no' AND meta_key = '$meta_key' 
                                    ORDER BY created_at DESC LIMIT 1";
                        $meta_result = mysqli_query($conn, $meta_sql);
                        $latest_meta = mysqli_fetch_assoc($meta_result);
                        $latest_pax[$meta_key] = (int) ($latest_meta['meta_value'] ?? 0);
                    }
                    $new_single_rooms = $latest_pax['single_rooms'] + $single_room;
                    $new_double_rooms = $latest_pax['double_rooms'] + $double_room;
                    $new_triple_rooms = $latest_pax['triple_rooms'] + $triple_room;
            
                    // Insert new meta values if there was a change
                    if ($single_room != 0) {
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                    VALUES ('$quoteid', '$sequence_no', 'single_rooms', '$new_single_rooms', NOW(), '$username_ajax')";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                    }
                    if ($double_room != 0) {
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                    VALUES ('$quoteid', '$sequence_no', 'double_rooms', '$new_double_rooms', NOW(), '$username_ajax')";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                    }
                    if ($triple_room != 0) {
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                    VALUES ('$quoteid', '$sequence_no', 'triple_rooms', '$new_triple_rooms', NOW(), '$username_ajax')";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                    }
                }
                if($cf_928 != 'Transfers') {
                    $sql = "INSERT INTO vtiger_itinerary 
                            (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                            VALUES ('$quoteid', '$sequence_no', 'booking_status', 'Pending', NOW(), '$username_ajax')";
                    mysqli_query($conn, $sql) or die(mysqli_error($conn));
                } else {
                    $sql = "INSERT INTO vtiger_itinerary 
                            (quoteid, sequence_no, sub_seq_no, meta_key, meta_value, created_at, created_by) 
                            VALUES ('$quoteid', '$sequence_no', '0', 'booking_status', 'Pending', NOW(), '$username_ajax')";
                    mysqli_query($conn, $sql) or die(mysqli_error($conn));
                }
            }

            // Prepare details for adjustment history
            $details = "Adjusted Pax Details:\n";
            if ($adults !== 0) $details .= "Adults: " . ($adults > 0 ? "+$adults" : $adults) . "\n";
            if ($children !== 0) $details .= "Children: " . ($children > 0 ? "+$children" : $children) . "\n";
            if ($infants !== 0) $details .= "Infants: " . ($infants > 0 ? "+$infants" : $infants) . "\n";
            if ($single_room !== 0) $details .= "Single Rooms: " . ($single_room > 0 ? "+$single_room" : $single_room) . "\n";
            if ($double_room !== 0) $details .= "Double Rooms: " . ($double_room > 0 ? "+$double_room" : $double_room) . "\n";
            if ($triple_room !== 0) $details .= "Triple Rooms: " . ($triple_room > 0 ? "+$triple_room" : $triple_room) . "\n";
        
            // Insert adjustment history with details
            $sql2 = "INSERT INTO vtiger_invoice_adjustment_history (quoteid, details, created_by) 
                    VALUES ('$quoteid', '" . mysqli_real_escape_string($conn, $details) . "', '$username_ajax')";
            mysqli_query($conn, $sql2);

            $insert_id = mysqli_insert_id($conn);
            $revert_data = json_encode($_POST, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
            $insert_revert = "INSERT INTO vtiger_invoice_adjustment_revert (auto_id, quoteid, adjustment_type, revert_data, created_by) 
                              VALUES ('$insert_id', '$quoteid', '$adjustment_type', '" . mysqli_real_escape_string($conn, $revert_data) . "', '$username_ajax')";
            mysqli_query($conn, $insert_revert);
        
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false, 'error' => mysqli_error($conn)]);
        }
    } else if ($adjustment_type === 'refund') {
        // Refund logic
        $quoteid = mysqli_real_escape_string($conn, $_POST['quoteid']);
        $category = mysqli_real_escape_string($conn, $_POST['category']);
        $sequence_no = mysqli_real_escape_string($conn, $_POST['product']);
        $refund_amount = (float) mysqli_real_escape_string($conn, $_POST['refund_amount']);
        $refund_reason = mysqli_real_escape_string($conn, $_POST['refund_reason']);
        $pax_deduction = (int) mysqli_real_escape_string($conn, $_POST['pax_deduction']);
        $reduction_category = mysqli_real_escape_string($conn, $_POST['reduction_category']);
        $reference_email_id = mysqli_real_escape_string($conn, $_POST['reference_email_id']); 

        $query = "SELECT meta_value FROM vtiger_itinerary WHERE quoteid='$quoteid' AND sequence_no='$sequence_no' AND meta_key='adults' ORDER BY created_at DESC LIMIT 1";
        $result = mysqli_query($conn, $query);
        $row = mysqli_fetch_assoc($result);
        if ($row) {
            // Step 2: Apply deduction to meta_value
            $old_meta_value = (int) $row['meta_value'];
            $new_meta_value = $old_meta_value - $pax_deduction;

            // Step 3: Insert the new row with the updated meta_value
            $insert_query = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by)
                            VALUES ('$quoteid', '$sequence_no', 'adults', '$new_meta_value', NOW(), '$username_ajax')";
            mysqli_query($conn, $insert_query);
        }

        $query = "SELECT vp.productName FROM vtiger_inventoryproductrel vi
                    LEFT JOIN tdu_products vp ON vi.productid=vp.productid
                    WHERE vi.id='$quoteid' AND vi.sequence_no='$sequence_no'";
        $result = mysqli_query($conn, $query);
        $row = mysqli_fetch_assoc($result);
        if ($row) {
            $product = $row['productName'];
        }

        $sql = "INSERT INTO vtiger_invoice_refunds (quoteid, category, product, refund_amount, refund_reason, created_by) 
                VALUES ('$quoteid', '$category', '$product', '$refund_amount', '$refund_reason', '$username_ajax')";

        if (mysqli_query($conn, $sql)) {
            $unique_void_id = mysqli_insert_id($conn);
            $_POST['unique_void_id'] = $unique_void_id;

            $details = "Reduction\nCategory: $category\nProduct: $product\nReduction Amount: $$refund_amount\nCategory: $reduction_category\nReason: $refund_reason\nReference Email ID: $reference_email_id";

            // Insert into the history table
            $sql2 = "INSERT INTO vtiger_invoice_adjustment_history (quoteid, details, created_by) 
                    VALUES ('$quoteid', '" . mysqli_real_escape_string($conn, $details) . "', '$username_ajax')";
            mysqli_query($conn, $sql2);

            $insert_id = mysqli_insert_id($conn);
            $revert_data = json_encode($_POST, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
            $insert_revert = "INSERT INTO vtiger_invoice_adjustment_revert (auto_id, quoteid, adjustment_type, revert_data, created_by) 
                              VALUES ('$insert_id', '$quoteid', '$adjustment_type', '" . mysqli_real_escape_string($conn, $revert_data) . "', '$username_ajax')";
            mysqli_query($conn, $insert_revert);

            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false, 'error' => mysqli_error($conn)]);
        }
    } else {
        echo json_encode(['success' => false, 'error' => 'Invalid adjustment type.']);
    }

    $sql = "INSERT INTO vtiger_invoice (quoteid, type, created_by) 
            VALUES ('$quoteid', 'adjust', '$username_ajax')";
    mysqli_query($conn, $sql) or die(mysqli_error($conn));

    mysqli_close($conn);
}

?>
