<?php
require 'email/vendor/autoload.php';
use GuzzleHttp\Client;

include "dbconn.php";

if (isset($_GET['attachment_id']) && isset($_GET['file_name']) && isset($_GET['message_id'])) {
    $attachmentId = htmlspecialchars($_GET['attachment_id']);
    $fileName = htmlspecialchars($_GET['file_name']);
    $messageId = htmlspecialchars($_GET['message_id']);

    $sql = "SELECT o.access_token FROM tdu_attachments a
            JOIN oauth_tokens o ON a.email_id=o.email
            WHERE a.attachment_id='$attachmentId'";
    $result = mysqli_query($conn, $sql);

    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $accessToken = $row['access_token'];
    } else {
        echo "Failed to retrieve the access token.";
        exit;
    }

    try {
        // Use Guzzle to fetch the attachment from Microsoft Graph
        $httpClient = new Client();
        $response = $httpClient->request('GET', "https://graph.microsoft.com/v1.0/me/messages/$messageId/attachments/$attachmentId", [
            'headers' => [
                'Authorization' => 'Bearer ' . $accessToken,
                'Accept'        => 'application/json',
            ],
        ]);

        $attachment = json_decode($response->getBody()->getContents(), true);

        if ($attachment['@odata.type'] == '#microsoft.graph.fileAttachment') {
            $fileContent = base64_decode($attachment['contentBytes']);

            // Set headers to prompt file download
            header('Content-Description: File Transfer');
            header('Content-Type: ' . $attachment['contentType']);
            header('Content-Disposition: attachment; filename="' . $fileName . '"');
            header('Content-Length: ' . strlen($fileContent));

            // Output the file content
            echo $fileContent;
            exit;
        }
    } catch (Exception $e) {
        echo "Failed to download attachment: " . $e->getMessage();
    }
}
?>
