<?php
require 'email/vendor/autoload.php';
use GuzzleHttp\Client;

include "dbconn.php";

if (isset($_GET['message_id'])) {
    $messageId = htmlspecialchars($_GET['message_id']);

    // Fetch the access token
    $sql = "SELECT o.access_token FROM tdu_emails e
            JOIN oauth_tokens o ON e.mailbox=o.email
            WHERE e.msgid='$messageId'";
    $result = mysqli_query($conn, $sql);

    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $accessToken = $row['access_token'];
    } else {
        echo "Failed to retrieve the access token.";
        exit;
    }

    try {
        // Use Guzzle to fetch all attachments for the message
        $httpClient = new Client();
        $response = $httpClient->request('GET', "https://graph.microsoft.com/v1.0/me/messages/$messageId/attachments", [
            'headers' => [
                'Authorization' => 'Bearer ' . $accessToken,
                'Accept'        => 'application/json',
            ],
        ]);

        $attachments = json_decode($response->getBody()->getContents(), true);

        if (!empty($attachments['value'])) {
            $filePaths = []; // Array to store file paths
            foreach ($attachments['value'] as $attachment) {
                if ($attachment['@odata.type'] == '#microsoft.graph.fileAttachment') {
                    $fileName = $attachment['name'];
                    $fileContent = base64_decode($attachment['contentBytes']);
        
                    // Save the file temporarily
                    $tempPath = 'temp/' . $fileName;
                    file_put_contents($tempPath, $fileContent);
        
                    // Store the file path
                    $filePaths[] = $tempPath;
                }
            }
            echo json_encode($filePaths);
        }
        
    } catch (Exception $e) {
        echo "Failed to fetch attachments: " . $e->getMessage();
    }
}
?>
