<?php
include "dbconn.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $templateName = mysqli_real_escape_string($conn, $_POST['templateName']);
    $templateCategory = mysqli_real_escape_string($conn, $_POST['templateCategory']);
    $quoteid = mysqli_real_escape_string($conn, $_POST['quoteid']);
    $country = mysqli_real_escape_string($conn, $_POST['country']);
    $templateHighlights = mysqli_real_escape_string($conn, $_POST['templateHighlights']);
    $templateType = mysqli_real_escape_string($conn, $_POST['templateType']);
    $templateCity = mysqli_real_escape_string($conn, $_POST['templateCity'] ?? '');

    $sql = "SELECT auto_id, day, tour_time, event_name FROM vtiger_itinerary_new_event
            WHERE quoteid='$quoteid'
            ORDER BY day ASC, tour_time ASC;";
    $result = mysqli_query($conn, $sql);
    $eventsArray = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $day = $row['day'];
        if (!isset($eventsArray[$day])) {
            $eventsArray[$day] = [];
        }
        $eventsArray[$day][] = [
            'auto_id' => $row['auto_id'],
            'tour_time' => $row['tour_time'],
            'event_name' => $row['event_name']
        ];
    }

    // Insert into tdu_templates
    $sql = "INSERT INTO tdu_templates (templatename, category, sourcequoteid, country, highlights, type) VALUES ('$templateName', '$templateCategory', '$quoteid', '$country', '$templateHighlights', '$templateType')";
    if (mysqli_query($conn, $sql)) {
        $templateid = mysqli_insert_id($conn);

        // Retrieve data from vtiger_inventoryproductrel
        $query = "SELECT i.day, i.productid, i.sequence_no, vit.meta_value AS tourtime FROM vtiger_inventoryproductrel i
                  LEFT JOIN vtiger_display_order o ON i.id=o.id AND i.sequence_no=o.sequence_no
                  LEFT JOIN (
                            SELECT t.quoteid, t.sequence_no, t.meta_value
                            FROM vtiger_itinerary t
                            JOIN (
                                SELECT quoteid, sequence_no, MAX(created_at) AS max_created_at
                                FROM vtiger_itinerary
                                WHERE meta_key = 'tourtime'
                                GROUP BY quoteid, sequence_no
                            ) latest ON t.quoteid = latest.quoteid 
                                AND t.sequence_no = latest.sequence_no
                                AND t.created_at = latest.max_created_at
                            WHERE t.quoteid = '$quoteid' AND t.meta_key = 'tourtime'
                        ) vit ON i.id=vit.quoteid AND i.sequence_no = vit.sequence_no
                  WHERE i.id='$quoteid' ORDER BY o.display_order ASC";
        $result = mysqli_query($conn, $query);

        $sequence_no = 1;
        $city_nights = [];  // Store city:nights pairs
        $total_nights = 0;
        $min_seater = 0;
        $usedEvents = [];

        while ($row = mysqli_fetch_assoc($result)) {
            $day = $row['day'];
            $tourtime = $row['tourtime'];
            $productid = $row['productid'];
            $seq_index = $row['sequence_no'];

            // Fetch category and city
            $productQuery = "SELECT category, city, seats FROM tdu_products WHERE productid='$productid'";
            $productResult = mysqli_query($conn, $productQuery);
            $productData = mysqli_fetch_assoc($productResult);
            
            $category = $productData['category'];
            $city = $productData['city'];
            $seaters = $productData['seats'];

            if(trim($templateCity) != '' && trim($templateCity) != trim($city)) {
                continue;
            }

            if ($category == 'Hotel') {
                $sequence_no1 = $row['sequence_no'];
                $sql_checkin = "SELECT meta_value FROM vtiger_itinerary 
                                WHERE quoteid = '$quoteid' AND sequence_no = '$sequence_no1' AND meta_key = 'check_in' 
                                ORDER BY created_at DESC 
                                LIMIT 1";
                $result_checkin = mysqli_query($conn, $sql_checkin);
                $checkin = mysqli_fetch_assoc($result_checkin)['meta_value'];

                $sql_checkout = "SELECT meta_value FROM vtiger_itinerary 
                                 WHERE quoteid = '$quoteid' AND sequence_no = '$sequence_no1' AND meta_key = 'check_out' 
                                 ORDER BY created_at DESC 
                                 LIMIT 1";
                $result_checkout = mysqli_query($conn, $sql_checkout);
                $checkout = mysqli_fetch_assoc($result_checkout)['meta_value'];

                if (!isset($city_nights[$city])) {
                    $city_nights[$city] = 0;
                }

                // Calculate nights
                $nights = (strtotime($checkout) - strtotime($checkin)) / (60 * 60 * 24);
                $city_nights[$city] += $nights;
                $total_nights += $nights;
            }
            if ($category == 'Transfers') {
                if($seaters > 0) {
                    if($min_seaters == 0 || $min_seaters > $seaters) {
                        $min_seaters = $seaters;
                    }
                }
            }

            if (!empty($day) && isset($eventsArray[$day])) {
                foreach ($eventsArray[$day] as $event) {
                    if (!in_array($event['auto_id'], $usedEvents) && (empty($tourtime) || $event['tour_time'] < $tourtime)) {
                        $tourtime1 = $event['tour_time'];
                        $event_name = $event['event_name'];
                        $insertSql = "INSERT INTO tdu_template_products (templateid, day, event_time, event_name, sequence_no, productid) 
                                      VALUES ('$templateid', '$day', '$tourtime1', '$event_name', '$sequence_no', '0')";
                        mysqli_query($conn, $insertSql);
                        $sequence_no++;
    
                        $usedEvents[] = $event['auto_id']; // Mark event as used
                    }
                }
            }

            $insertSql = "INSERT INTO tdu_template_products (templateid, day, event_time, sequence_no, productid) 
                          VALUES ('$templateid', '$day', '$tourtime', '$sequence_no', '$productid')";
            mysqli_query($conn, $insertSql);
            $sequence_no++;
        }

        // Update city column with city:nights data
        $city_nights_string = implode(",", array_map(fn($city, $nights) => "$city:$nights", array_keys($city_nights), $city_nights));
        $num_cities = count($city_nights);
        if($templateCategory == 'SIC') {
            $min_seaters = $_POST['template_pax_num'] ?? 0;
        }
        $updateCitySql = "UPDATE tdu_templates SET city='$city_nights_string', nights='$total_nights', num_cities='$num_cities', seaters='$min_seaters' WHERE templateid='$templateid'";
        mysqli_query($conn, $updateCitySql);

        echo "Template successfully saved!";
    } else {
        echo "Error: " . mysqli_error($conn);
    }

    mysqli_close($conn);
} else {
    echo "Invalid request.";
}
?>
